#ifndef _CONNECTION_H_
#define _CONNECTION_H_

#include <iostream>
using namespace std;

class Connection {
public:
    Connection() {}
    virtual ~Connection() {}
    virtual void connect(const char *hostname, const char *port) = 0;
    virtual int write(char *buf, int len) = 0;
    virtual int write(std::string string) = 0;
    virtual int read(char *buf, int len) = 0;
    virtual std::string readall() = 0;
    virtual std::string readLine() = 0;
    virtual void close() = 0;
    virtual void flush() = 0;
    virtual bool isConnected() const = 0;
};

class ConnectException {
public:
    const char *_what;
    ConnectException(const char *what)
        : _what(what)
    {}

    const char * what() {
        return _what;
    }
};

#endif
