import java.io.IOException;

import junit.framework.TestCase;


public class CloudWarsTests extends TestCase {
	
	public void testAngle(){
		Vector e = new Vector(1, 0);
		assertAngle(e, 0);
		Vector ne = new Vector (1,1);
		assertAngle(ne, Math.PI/4);
		Vector n = new Vector (0,1);
		assertAngle(n, Math.PI/2);
		Vector nw = new Vector (-1, 1);
		assertAngle(nw, 3*Math.PI/4);
		Vector w = new Vector (-1, 0);
		assertAngle(w, Math.PI);
		Vector sw = new Vector (-1, -1);
		assertAngle(sw, 5*Math.PI/4);
		Vector s = new Vector (0, -1);
		assertAngle(s, 6*Math.PI/4);
		Vector se = new Vector (1, -1);
		assertAngle(se, 7*Math.PI/4);
		
	}
	
	public void assertAngle(Vector v, double angle){
		float diff = Math.abs(v.angle() - (float) angle);
		System.out.println(v + ": v.angle():" + v.angle() + " , angle: " + angle + " , diff:" + diff);
		assertTrue(diff < 0.01);
	}
	
	public void testUpdate(){
		try {
			Client client = new Client(){

				@Override
				public void RunAi() throws IOException, InterruptedException {
					SetName("TestAI");
					
				}
			};
			DebugWriter writer = client.debugWriter;
			GameState gs0 = client.GetState();
			writer.writeTurnStart();
			writer.writeTurnEnd();
			GameState gs1 = gs0.clone();
			Thread.sleep(500);
			GameState gs2 = client.GetState();
			writer.writeTurnStart();
			writer.writeTurnEnd();
			gs1.update(gs2.iteration - gs0.iteration);
			gs1.WriteToStream(client.debugWriter);
			GameState gs3 = client.GetState();
			writer.writeTurnStart();
			writer.writeTurnEnd();
			client.Wind(100, 100);
			GameState gs4 = gs3.clone();
			gs4.applyWind(new Vector(100,100));
		
			Thread.sleep(5000);
			GameState gs5 = client.GetState();
			writer.writeTurnStart();
			writer.writeTurnEnd();
			gs4.update(gs5.iteration - gs3.iteration);
			gs4.WriteToStream(client.debugWriter);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
