import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MyAi extends Client {
	private GameState currentState;
	private GameState lastState;
	private Vector lastBestVector;
	private Cloud me;

	int max_iterations = 200;
	int max_millis = 200;
	
	public MyAi() throws IOException, InterruptedException {
		super();
		//don't put stuff here, super calls RunAi loop
	}


	//    @Override
	//    public GameState GetState() {
	//    	GameState gs =  super.GetState();
	//    	//debugger.addGameState(gs);
	//    	return gs;
	//    
	//    }
	// Implement your AI here
	// Use these functions to communicate with server:
	//    SetName(name) - Sets your name to appear in the simulator
	//    GetState() - returns the current GameState object
	//    Wind(x, y) - applies a wind in the given direction (returns true if OK, false if IGNORED)
	@Override
	public void RunAi() throws IOException, InterruptedException {
		Thread.sleep(500);
		SetName("Medrakil");
		//debugger = new Debugger();
		lastState = GetState();
		lastBestVector = new Vector(0, 0);
		while (Connected()) {
			// Poll the game state

			currentState = GetState();
			if (currentState == null) break;
			me = currentState.Me();
			debugWriter.writeTurnStart();
			Map<GameState, Vector> states = getFutureStates(currentState);
			GameState coastState = currentState.clone();
			float currentRating = rate(coastState);
			states.put(coastState, new Vector(0,0));
			int coastIters = currentState.iteration - lastState.iteration;
			debugWriter.writeLog(Log.VERBOSE, "CoastIters: " + coastIters);
			long startingMillis = System.currentTimeMillis();
			int iterations = 0;
			while (true){
				for(GameState gs : states.keySet()){
					gs.update(5);
				}
				iterations += 5;
				long time = System.currentTimeMillis() - startingMillis ; 
				if(iterations > max_iterations){
					debugWriter.writeLog(Log.DEBUG, "max iterations, " + time + "ms" );
					break;
				}
				if(time > max_millis){
					debugWriter.writeLog(Log.DEBUG, "max time, " + iterations + "iters" );
					break;
				}
				if(rate(coastState) < currentRating && iterations > 20){
					debugWriter.writeLog(Log.WARNING, "Evade!");
					break;
				}
			}
			float maxRating = Float.MIN_VALUE;
			Vector bestVector = new Vector(0,0);
			for(GameState gs : states.keySet()){
				float r = rate(gs);
				Vector v = states.get(gs);
				
				if(r > maxRating){					
					bestVector = v;
					maxRating = r;
					//System.out.println("Temporary winner: " + v + ", resulting in " + r + " rating");
				}
			}
			Wind(bestVector);
			debugWriter.writeTurnEnd();
			lastState.applyWind(lastBestVector);
			lastState.update(currentState.iteration - lastState.iteration);
			lastState.WriteToStream(debugWriter);
			lastState = currentState.clone();
			lastBestVector = bestVector;
			max_iterations += 10;
			max_millis += 10;
		}
	}
	public static float rate (GameState gs){
		if(gs.MeIndex < gs.Thunderstorms.size()){
			return gs.Me().Vapor;
		}
		return Float.MIN_VALUE;
	}
	//private List<GameState> getFutureStates(GameState currentState){
	private Map<GameState, Vector> getFutureStates(GameState currentState){
		Map<GameState, Vector> resultMap = new HashMap<GameState, Vector>();
		List<GameState> result = new ArrayList<GameState>();
		List<Vector> winds = getWinds(currentState.Me().Vapor);
		for(Vector v : winds){
			GameState gs = currentState.clone();
			gs.applyWind(v);
			result.add(gs);
			resultMap.put(gs, v);
		}
		
//		return result;
		return resultMap;
	}
	
	private List<Vector> getWinds(float myVapor){
		final int ANGLES = 12; 
		List<Vector> possibleWinds = new ArrayList<Vector>();
		
		final float dw = 2*(float)Math.PI / ANGLES;
        for (int i = 0; i < ANGLES; i++)
        {
            float angle = i * dw;
            possibleWinds.add(Vector.byAngle(angle, myVapor * 0.075f));
            possibleWinds.add(Vector.byAngle(angle, myVapor * 0.2f));
            possibleWinds.add(Vector.byAngle(angle, myVapor * 0.4f));
        }
        return possibleWinds;
	}

	private void move() throws IOException, InterruptedException{
		Vector myFuturePos = me.futurePos();
		List<Cloud> targets = new ArrayList<Cloud>();

		for (Cloud c: currentState.Thunderstorms){
			if(me.Vapor * (float) 0.85 > cost(currentState, c.Position) + c.Vapor){
				//aim(getAimPoint(currentState, c), me.Vapor * (float)0.15);
				Log.d("POUNCE!");
				//Thread.sleep(200);
				//return;
			}
		}
		float minVapor = me.Vapor * (float) 0.04;
		List<Cloud> clouds =currentState.Rainclouds; 
		clouds.addAll(currentState.Thunderstorms);
		float maxReward = -1;
		int bestIndex = -0;
		for (int i = 0; i < clouds.size(); i++){
			Cloud c = clouds.get(i); 
			if (c.Vapor > minVapor){
				float reward = reward (currentState, c);
				if(reward > maxReward && reward > 0){
					bestIndex = i;
					maxReward = reward;
				};
			}
		}
		if(bestIndex >= 0){
			Cloud target = clouds.get(bestIndex);
			aim(getAimPoint(currentState, target), me.Vapor * (float) 0.01 + target.Vapor * (float) 0.01 );
		}
		

	}

	public static float reward(GameState gs, Cloud c){
		Cloud me = gs.Me();
		if(c.Vapor + cost(gs, c.Position) > me.Vapor){
			return - (me.Vapor * me.Vapor);
		}
		float distance = me.Position.getDistanceTo(c.Position);
		float diffspeed =  distance - me.futurePos().getDistanceTo(c.futurePos());
		float cost = cost(gs, c.futurePos());
		float reward = (float)1.5 * c.Vapor - cost;
		//Log.v("reward for cloud at " + c.Position.x + ", " + c.Position.y + ", distance " + distance + " with diffspeed " + diffspeed + " holding " + c.Vapor +  " vapor: " + reward + " , cost: " + cost);
		return  reward;
	}

	public static float cost(GameState gs, Vector target){
		Cloud me = gs.Me();
		float distancex = (target.x - me.Position.x);
		float distancey = (target.y - me.Position.y);
		Vector distance = new Vector (distancex, distancey);
		float targetAngle = distance.angle();
		Vector newDir = Vector.byAngle(targetAngle, distance.length());
		Vector wind = new Vector (newDir.x - me.Velocity.x, newDir.y - me.Velocity.y); 
		return wind.length();
	}
	
	public Vector getAimPoint(GameState gs, Cloud target){
		Cloud me = gs.Me();
		float distance = me.Position.getDistanceTo(target.Position);
		float nextDistance = me.futurePos(5).getDistanceTo(target.futurePos(5));
		float time = distance / (me.Velocity.length());
		int iterations = Math.min(25, (int)time);
		try {
			debugWriter.writeLog(Log.DEBUG, "Iterations:" + iterations);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if(iterations > 0){
			return target.futurePos(iterations);
		}
		return target.Position;
	}
	
	private void aim(Vector target, float vapor) throws IOException{
		debugWriter.writeTarget(target.x, target.y);

		float distancex = (target.x - me.Position.x);
		float distancey = (target.y - me.Position.y);
		Vector distance = new Vector (distancex, distancey);
		float targetAngle = distance.angle();
		Vector newDir = Vector.byAngle(targetAngle, vapor);
		Vector wind = new Vector (newDir.x - me.Velocity.x, newDir.y - me.Velocity.y); 

		if(wind.length() > 1 || me.Velocity.length() < 15){
			//Log.v("Fire!");
			debugWriter.writeWind(wind.x, wind.y);
			Wind(wind);
		}else{
			//Log.v("Don't fire! " + me.Velocity.length() );
		}
	}

	public static void main(String[] args) {
		try {
			MyAi ai = new MyAi();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}


