import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GameState {
    public ArrayList<Cloud> Thunderstorms = new ArrayList<Cloud>();
    public ArrayList<Cloud> Rainclouds = new ArrayList<Cloud>();
    public int MeIndex;
    public int iteration;
    private static float totalVapor = -1;

    public Cloud Me() {
        return Thunderstorms.get(MeIndex);
    }
    
    public List<Cloud> allClouds(){
    	List<Cloud> list = new ArrayList<Cloud>();
    	list.addAll(Thunderstorms);
    	list.addAll(Rainclouds);
    	return list;
    }
    
    public float totalVapor (){
    	//memoize
    	if(totalVapor < 0){
    		totalVapor = 0;
    		for (Cloud c: Thunderstorms){
    			totalVapor += c.Vapor;
    		}
    		for (Cloud c: Rainclouds){
    			totalVapor += c.Vapor;
    		}
    	}
    	return totalVapor;
    }
    
    public GameState clone(){
    	GameState gs = new GameState();
    	for(Cloud c: Thunderstorms){ gs.Thunderstorms.add(c.clone());}
    	for(Cloud c: Rainclouds){gs.Rainclouds.add(c.clone());}
    	gs.MeIndex = MeIndex;
    	gs.iteration = iteration;
    	return gs;
    }
    
    public void resetTo(GameState gs){
    	Thunderstorms.clear();
    	Rainclouds.clear();
    	for(Cloud c: gs.Thunderstorms){ Thunderstorms.add(c.clone());}
    	for(Cloud c: gs.Rainclouds){Rainclouds.add(c.clone());}
    	MeIndex = gs.MeIndex;
    	iteration = gs.iteration;
    }
    
    public void applyWind(Vector v){
    	Cloud me = Me();
    	float strength = v.length();
    	me.Vapor -= strength;
    	float radius = me.Radius();
    	me.Velocity.x += (v.x * 5 / radius );
    	me.Velocity.y += (v.y * 5 / radius);
    	
    	float wx = v.x/strength;
    	float wy = v.y/strength;
    	float distance = ((float)Math.sqrt(strength) + radius) * 1.1f; 
    	
    	Cloud resultCloud = new Cloud(me.Position.x - wx * distance, me.Position.y - wy * distance, -(v.x/strength) * 20 + me.Velocity.x , -(v.y/strength) * 20 + me.Velocity.y, strength);
    	Rainclouds.add(resultCloud);
    }
    
    private boolean intersects(Cloud a, Cloud b, float distance){
    	return distance < (a.Radius() + b.Radius());
    }
    
    public void update(int iterations){
    	iteration += iterations;
    	List<Cloud> allClouds = allClouds();
    	for(int i = 0; i< iterations; i++){
    		for (Cloud c : allClouds){

    			c.Position.x += (c.Velocity.x * 0.1f);
    			c.Position.y += (c.Velocity.y * 0.1f);
    			
    			c.Velocity.x *= 0.999f;
    			c.Velocity.y *= 0.999f;
    			for (Cloud d : allClouds){
    				if (d == c) continue;

                    Cloud smallest = c.Vapor < d.Vapor ? c : d;
                    Cloud biggest = c.Vapor > d.Vapor ? c : d;

                    // If the cloud have exactly the same amount of vapor, it is random (but not undefined) which one is considered the largest
                    // with 50% probability for both A and B.
                    if (c.Vapor == d.Vapor)
                    {
                        if (Math.random() < 0.5)
                        {
                            smallest = c;
                            biggest = d;
                        }
                        else
                        {
                            smallest = d;
                            biggest = c;
                        }
                    }
                    float distance = (float) (d.Position.getDistanceTo(c.Position));
                    // Check for intersection
                    while (intersects(c, d, distance))
                    {
                        if (smallest.Vapor < 1.0f)
                        {
                            break;
                        }
                        // Transfer vapor from the biggest to the smallest
                        biggest.Vapor += 1.0f;
                        smallest.Vapor -= 1.0f;
                    }
                }
                float myRadius = c.Radius();
                // Bounce against walls
                if (c.Position.x < myRadius)
                {
                    c.Position.x = myRadius;
                    c.Velocity.x = Math.abs(c.Velocity.x)*0.6f;
                }
                if (c.Position.y < myRadius)
                {
                    c.Position.y = myRadius;
                    c.Velocity.y = Math.abs(c.Velocity.y)*0.6f;
                }
                if (c.Position.x + myRadius > 1280)
                {
                    c.Position.x = 1280 - myRadius;
                    c.Velocity.x = -Math.abs(c.Velocity.x)*0.6f;
                }
                if (c.Position.y + myRadius > 720)
                {
                    c.Position.y = 720 - myRadius;
                    c.Velocity.y = -Math.abs(c.Velocity.y)*0.6f;
                }
            }
    	}
    }
    public void WriteToStream(DebugWriter sw) throws IOException
    {
        sw.write("BEGIN_STATE " + iteration + "\r\n") ;
        sw.write("YOU " + MeIndex + "\r\n");
        for(Cloud ts : Thunderstorms)        {
            sw.write("THUNDERSTORM " + ts.Position.x + " " + ts.Position.y + " " + ts.Velocity.x + " " +
                      ts.Velocity.y + " " + ts.Vapor + "\r\n");
        }
        for(Cloud rc : Rainclouds)
        {
            sw.write("RAINCLOUD " + rc.Position.x + " " + rc.Position.y + " " + rc.Velocity.x + " " +
                      rc.Velocity.y + " " + rc.Vapor + "\r\n");
        }
        sw.write("END_STATE" + "\r\n");
        sw.write("TURN_START" + "\r\n");
        sw.write("TURN_END" + "\r\n");

        sw.flush();
    }
}
