import java.io.File;
import java.io.FileDescriptor;
import java.io.FileWriter;
import java.io.IOException;

public class DebugWriter  {
	public static final String TURN_START = "TURN_START";
	public static final String TURN_END = "TURN_END";
	public static final String WIND = "WIND";
	public static final String TARGET = "TARGET";
	public static final String LOG = "LOG";
	private FileWriter fw;

	public static final boolean ENABLED = true;
	
	public DebugWriter(File arg0) throws IOException {
		if(ENABLED){
			fw = new FileWriter(arg0);
		}
		// TODO Auto-generated constructor stub
	}

	public DebugWriter(String arg0) throws IOException {
		if(ENABLED){
			fw = new FileWriter(arg0);
		}
		// TODO Auto-generated constructor stub
	}
		
	public DebugWriter getDebugWriter(String filename) throws IOException{
		if(ENABLED){
			return new DebugWriter(filename);
		}else{
			return new DebugWriter("");
		}
	}
	
	public void write(String str) throws IOException {
		if(ENABLED){
			fw.write(str);
		}
	}
	
	public void flush() throws IOException{
		if(ENABLED){
			fw.flush();
		}
	}
	
	public void writeTurnStart() throws IOException{
		write(TURN_START + "\r\n");
	}
	
	public void writeTurnEnd() throws IOException{
		write(TURN_END + "\r\n");
	}
	
	public void writeWind(float x, float y) throws IOException{
		write(WIND + " " + x + " " + y + "\r\n");
	}
	
	public void writeTarget(float x, float y) throws IOException{
		write(TARGET + " " + x + " " + y + "\r\n");
	}
	
	public void writeLog (int level, String message ) throws IOException {
		write(LOG + " " + level + " " + message + "\r\n");
		System.out.println(message);
	}
	
	
}
