import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;


public class DebugReader {
	private BufferedReader reader;
	
	public DebugReader(File file) throws FileNotFoundException{
		reader = new BufferedReader(new FileReader(file));
	}
	
	public GameTurn GetTurn() {
        try {
            String line = "";
//            if (!started) {
//                line = reader.readLine();
//                while (line == null || !line.equals("START")) {
//                    line = reader.readLine();
//                }
//                started = true;
//            }


            GameTurn state = new GameTurn();
            boolean end = false;
            while (!end) {
            	if(!reader.ready()){
            		break;
            	}
                line = reader.readLine();
                if (line != null) {
                    String[] msg = line.split("\\s+");
                    String key = msg[0];
                    if (key.equals("BEGIN_STATE")) {
                        int iteration = Integer.parseInt(msg[1]);
                        System.out.print("Receiving state for iteration " + iteration);
                        state.iteration = iteration;
                    } else if (key.equals("END_STATE")) {
                        System.out.println("End of state tag");
                        //end = true;
                    } else if (key.equals("THUNDERSTORM")) {
                        state.Thunderstorms.add(
                                new Cloud(
                                        Float.parseFloat(msg[1]),
                                        Float.parseFloat(msg[2]),
                                        Float.parseFloat(msg[3]),
                                        Float.parseFloat(msg[4]),
                                        Float.parseFloat(msg[5])));

                    } else if (key.equals("RAINCLOUD")) {
                        state.Rainclouds.add(
                                new Cloud(
                                        Float.parseFloat(msg[1]),
                                        Float.parseFloat(msg[2]),
                                        Float.parseFloat(msg[3]),
                                        Float.parseFloat(msg[4]),
                                        Float.parseFloat(msg[5])));

                    } else if (key.equals("YOU")) {
                        state.MeIndex = Integer.parseInt(msg[1]);
                    } else if (key.equals(DebugWriter.TURN_START)) {
                    	System.out.println("Turn begins");
                    } else if (key.equals(DebugWriter.TURN_END)) {
                    	System.out.println("Turn ends");
                    	end = true;
                    } else if (key.equals(DebugWriter.TARGET)) {
                    	state.target = new Vector(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]) );
                    } else if (key.equals(DebugWriter.WIND)) {
                    	state.wind = new Vector(Float.parseFloat(msg[1]), Float.parseFloat(msg[2]) );
                    } else if (key.equals(DebugWriter.LOG)){
                    	state.addLogMessage(msg[2]);
                    }
                }
            }
            return state;
        } catch (Exception e) {
            return null;
        }
    }
}
