﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Windows;

namespace ClientAI
{
	public partial class Client
	{
		float x = 0;
		float y = 0;

		// Implement your AI here
		// Use these functions to communicate with server:
		//    SetName(name) - Sets your name to appear in the simulator
		//    GetState() - returns the current GameState object
		//    Wind(x, y) - applies a wind in the given direction (returns true if OK, false if IGNORED)
		public void RunAI()
		{
			SetName("iNstein");

			while (Connected)
			{
				// Poll the game state
				GameState state = GetState();
				if (state != null)
				{
					// Init
					bool Refresh = false;
					int MeIndex = state.MeIndex;
					float MyRadius = state.Me.Radius;
					float MyVapor = state.Me.Vapor;
					Vector MyVelocity = state.Me.Velocity;
					Vector MyPosition = state.Me.Position;
					List<Cloud> RainClouds = state.Rainclouds;
					List<Cloud> StormClouds = state.Thunderstorms;

					Cloud Enemy = FindEnemy(StormClouds, MeIndex);

					// Actions
					// Check if enemy is DangerClose
					if (Bigger(Enemy, MyVapor) && Proximity(100, Enemy, MyPosition))
					{
						TakeEvasiveAction(Enemy, MyRadius, MyPosition);
						Refresh = true;
					}

					//// Check if any raincloud is DangerClose
					if (!Refresh)
					{
						foreach (Cloud RainCloud in RainClouds)
						{
							if (Bigger(RainCloud, MyVapor) && Proximity(100, RainCloud, MyPosition))
							{
								TakeEvasiveAction(RainCloud, MyRadius, MyPosition);
								Refresh = true;
								break;
							}
						}
					}

					// No immenent danger: Eat enemy!
					if (!Refresh)
					{
						if (Eat(Enemy, MyVapor))
						{
							Wind((float)Enemy.Position.X / 7, (float)Enemy.Position.Y / 7);
							Refresh = true;
						}
					}

					// Om nom nom!
					if (!Refresh)
					{
						EatRainCloud(RainClouds, MyVapor, MyRadius, MyPosition, MyVelocity);
					}
				}
				Thread.Sleep(0);
			}
		}

		private Cloud FindEnemy(List<Cloud> StormClouds, int MeIndex)
		{
			try
			{
				if (MeIndex != 0)
					return StormClouds[0];
				return StormClouds[1];
			}
			catch (Exception)
			{
				return null;
			}
		}

		private bool Proximity(float Limit, Cloud Target, Vector MyPosition)
		{
			if (Target.Position.X < (MyPosition.X + Limit) &&
				!(Target.Position.X < MyPosition.X) &&
				  Target.Position.Y < (MyPosition.Y + Limit) &&
				!(Target.Position.Y < MyPosition.Y))
				return true;
			return false;
		}

		private bool Bigger(Cloud Target, float MyVapor)
		{
			if (Target != null && MyVapor != null)
			{
				if ((Target.Vapor + 50) > MyVapor)
					return true;
			}
			return false;
		}

		private void TakeEvasiveAction(Cloud Enemy, float MyRadius, Vector MyPosition)
		{
			x = (float)Enemy.Position.X / 4;
			y = (float)Enemy.Position.Y / 8;
			Wind(x, y);
		}

		private bool Eat(Cloud Food, float MyVapor)
		{
			if (Food != null && MyVapor != null)
			{
				if (MyVapor > (Food.Vapor + 100))
					return true;
			}
			return false;
		}

		private void EatStormCloud(Cloud Enemy, float MyVapor, Vector MyPosition, Vector MyVelocity)
		{
			if (!Bigger(Enemy, MyVapor))
			{
				x = Thrust(Enemy.Position.X, MyVelocity.X);
				y = Thrust(Enemy.Position.Y, MyVelocity.Y);
				Wind(x, y);
			}
		}

		private void EatRainCloud(List<Cloud> RainClouds, float MyVapor, float MyRadius, Vector MyPosition, Vector MyVelocity)
		{
			//Cloud TheOne = new Cloud(0, 0, 0, 0, 0);

			foreach (Cloud RainCloud in RainClouds)
			{
				if (!Bigger(RainCloud, (MyVapor + 50)) && RainCloud.Vapor > 50 && MyVelocity.X < 3.5 && MyVelocity.Y < 3.5)
				{
					//if (Closer(RainCloud, TheOne, MyPosition))
					//    TheOne = RainCloud;
					x = Thrust(RainCloud.Position.X, MyVelocity.X);
					y = Thrust(RainCloud.Position.Y, MyVelocity.Y);
					Wind(x, y);
					break;
				}
			}
		}

		private bool Closer(Cloud Challenger, Cloud Current, Vector Me)
		{
			double totChallenger = Challenger.Position.X + Challenger.Position.Y;
			if (totChallenger == 0) return false;
			double totCurrent = Current.Position.X + Current.Position.Y;
			double totMe = Me.X + Me.Y;
			double diffChallenger = totChallenger - totMe;
			double diffCurrent = totCurrent - totMe;
			diffChallenger = Math.Abs(diffChallenger);
			diffCurrent = Math.Abs(diffCurrent);
			if (diffChallenger < diffCurrent)
				return true;
			return false;
		}

		private float Thrust(double Target, double MyVelocity)
		{
			if (MyVelocity > 5)
				return 0;
			return (float)(Target / 16 - MyVelocity);
		}
	}
}