#include "sim.h"
#include <algorithm>

using std::sort;

inline cloud& bounce_cloud(cloud& c) // this function introduces some small error
{
	const float r = sqrt(c.vap);
	if (c.pos.x < r)
	{
		c.pos.x = r - 0.6*(c.pos.x-r);
		c.vel.x = -0.6*c.vel.x;
	}
	if (c.pos.y < r)
	{
		c.pos.y = r - 0.6*(c.pos.y-r);
		c.vel.y = -0.6*c.vel.y;
	}
	const float hx = 1280-r;
	if (c.pos.x > hx)
	{
		c.pos.x = hx - 0.6*(c.pos.x-hx);
		c.vel.x = -0.6*c.vel.x;
	}
	const float hy = 720-r;
	if (c.pos.y > hy)
	{
		c.pos.y = hy - 0.6*(c.pos.y-hy);
		c.vel.y = -0.6*c.vel.y;
	}
	return c;
}

bool sort_by_vapor(const cloud* c1, const cloud* c2)
{
	return c1->vap < c2->vap;
}

/*
pr + (pv+dv)t = or + ovt
(pv+dv)t = or-pr + ovt
dvt = (or-pr) + (ov-pv)t
xt = at + b
(x-a)t = b
x-a = b/t
x = a + b/t
t = b/(x-a)
min xt = min at + b
min at + b => a.(b-at) = 0 => a.b - a.at = 0 => t = a.b/a.a => x = a + b(a.a/a.b) 
*/

vec2 oponent_move(cloud* pp, list<cloud*> clp)
{
	return vec2(0,0);
	const float maxt = 300;
	const float max_mdv = pp->vap*0.1*5/sqrt(pp->vap);
	float bestscore = 2;
	float best_t = 0;
	cloud* op = NULL;
	for (auto it = clp.begin(); it != clp.end(); it++) if (*it != pp && (*it)->vap*1.1 < pp->vap)
	{
		const vec2 a = (*it)->vel - pp->vel;
		const vec2 b = (*it)->pos - pp->pos;
		
		// |dv| < pV - oV
		// dv t = at + b
		// |dv| = |a+b/t|
		// dv.dvt^2 = t^2a.a + t(2a.b) + b.b
		// t^2(a.a-dv.dv) t(2a.b) + b.b = 0
		// 
		for (int t = 2; t < 128; t<<=1)
		{
			const vec2 tdv = (a*t+b)/t;
			if (length(tdv) < max_mdv)
			{
				const int score = (*it)->vap/t;
				if (bestscore < score)
				{
					bestscore = score;
					best_t = t;
					op = *it;
				}
			}
		}
	}
	if (op != NULL)
	{
		const vec2 a = op->vel - pp->vel;
		const vec2 b = op->pos - pp->pos;
		const vec2 dv = a + b/best_t;
		if (dot(dv,pp->pos-op->pos) < 0)
			return dv*(sqrt(pp->vap)/5);
		else
			return vec2(0,0);
	}
	else
		return vec2(0,0);
	return vec2(0,0);
}

cloud apply_wind(cloud& c, const vec2& wind)
{
	const float str = length(wind);
	if (str < 1 || str > c.vap/2)
		return cloud(vec2(0,0),vec2(0,0),0);

	c.vap -= str;
	c.vel += wind*(5/sqrt(c.vap));

	return cloud(c.pos - wind*(1.1*(sqrt(c.vap)+sqrt(str))/str), c.vel - wind*(20/str), str);
}

void apply_wind(state& s, const vec2& wind)
{
	s.rc.push_back(apply_wind(s.me, wind));
}

int low_vapor_limit = 1;
bool vapor_too_low(const cloud& c) { return c.vap < low_vapor_limit; }

int sim_max_turn;
int sim_max_skip(const state& s0) { return 5 + 7*s0.min_dist/s0.max_speed; }

state look_ahead(const state& s0, int turns)
{
	int max_turns = sim_max_skip(s0);
	if (s0.turn+turns > sim_max_turn)
		turns = sim_max_turn - s0.turn;
	state s1;
	if (turns > max_turns)
	{
		while (turns > max_turns)
		{
			s1 = look_ahead(s0, max_turns);
			turns -= max_turns;
			max_turns = sim_max_skip(s0);
		}
		return look_ahead(s1, turns);
	}

	const float vdamp0 = 0.999;
	float vmul = 0;
	float vdamp = 1;
	list<cloud*> allc;

	s1.max_speed = 0;
	s1.min_dist = 2000;
	
	s1.turn = s0.turn + turns;

	for (int i = 0; i < turns; i++)
	{
		vmul += vdamp*0.1;
		vdamp *= vdamp0;
	}
	s1.me.pos = s0.me.pos + s0.me.vel*vmul;
	s1.me.vel = s0.me.vel*vdamp;
	s1.me.vap = s0.me.vap;
	bounce_cloud(s1.me);
	allc.push_back(&s1.me);

	for (auto it = s0.tc.begin(); it != s0.tc.end(); it++)
	{
		s1.tc.push_back(bounce_cloud(cloud(it->pos+it->vel*vmul, it->vel*vdamp, it->vap)));
		allc.push_back(&s1.tc.back());
	}
	for (auto it = s0.rc.begin(); it != s0.rc.end(); it++)
	{
		s1.rc.push_back(bounce_cloud(cloud(it->pos+it->vel*vmul, it->vel*vdamp, it->vap)));
		allc.push_back(&s1.rc.back());
	}
	for (auto it = s1.tc.begin(); it != s1.tc.end(); it++)
	{
		const vec2 wind = oponent_move(&(*it), allc);
		if (length(wind) > 10)
		{
			s1.rc.push_back(apply_wind(*it, wind));
			allc.push_back(&s1.rc.back());
		}
	}

	float sumvap = 0;
	s1.lose = true;
	for (auto it = allc.begin(); it != allc.end(); it++)
	{
		cloud* ca = *it;
		sumvap += ca->vap;
		if (ca->vap > 1 && s1.me.vap > ca->vap)
			s1.lose = false;
		const float speed = length(ca->vel);
		if (s1.max_speed < speed)
			s1.max_speed = speed;
		for (auto jt = it; jt != allc.end(); jt++) if (jt != it)
		{
			cloud* cb = *jt;
			cloud* bgc;
			cloud* smc;
			if (ca->vap > cb->vap)	{	bgc = ca;	smc = cb;	}
			else					{	bgc = cb;	smc = ca;	}

			const float R = sqrt( bgc->vap );
			const float r = sqrt( smc->vap );
			const float d = length(bgc->pos - smc->pos);
			const float k = bgc->vap + smc->vap;
			if (s1.min_dist > d)
				s1.min_dist = d;
			if (d < R)
			{
				bgc->vap += smc->vap;
				smc->vap = 0;
			}
			else if (d < R+r)
			{
				if (2*k < d*d)
				{
					bgc->vap = k;
					smc->vap = 0;
				}
				else
				{
					const float diff = sqrt(2*k-d*d);
					const float newR = 0.5*(d+diff);
					bgc->vap = newR*newR;
					smc->vap = k - bgc->vap;
				}
			}
		}
	}
	for (auto it = allc.begin(); it != allc.end(); it ++) 
		if ((*it)->vap*2 > sumvap)
			s1.lose = true;
	if (s1.me.vap > sumvap-s1.me.vap)
	{
		s1.win = true;
		s1.lose = false;
	}
	//for (auto it = s1.tc.begin(); it != s1.tc.end(); )
	//	if (it->vap <= 1)
	//		it = s1.tc.erase(it);
	//	else
	//		it++;
	low_vapor_limit = 1;
	s1.tc.remove_if(vapor_too_low);
//	low_vapor_limit = s1.me.vap*0.1;
	s1.rc.remove_if(vapor_too_low);

	return s1;
}


/*
	R+r = d
	R^2 + r^2 = k
	R = d-r
	(d-r)^2 + r^2 = k
	d^2 - 2dr + r^2 + r^2 = k
	r^2 - dr + 1/2 (d^2 - k) = 0
	r = d/2 +/- sqrt(d^2 - 2(d^2 - k))/2
	r = d/2 +/- sqrt(2k - d^2)/2
*/
