#!/usr/bin/env python

import time
import threading
import random
import math
from ai import AI

global state

class Bot(AI):
 me = None
 vx = 0
 vy = 0
 onHunt = False
 inEvade = False
 iterationDelay = 0

 def __init__(self):
  AI.__init__(self)
  #self.connect("188.0.87.139", 1986)
  self.connect("127.0.0.1", 1986)
  self.name('chim')
  self.start()
  self.sleep(1)
  print "Game started!"
 
 def main_loop(self):
  sleepSeconds = 0.15
  if self.iterationDelay == 0:
   self.onHunt = False
   self.inEvade = False 
  self.iterationDelay -= 1

  state = self.getState()
  if state:
   self.me = state["me"]
   try:
    self.vx = self.me["vx"]
    self.vy = self.me["vy"]
   except:
    pass
   windT = (0,0)
   thunderstorms = self.weightThunderstorms(state["thunderstorms"])
   rainclouds = self.getCloudWeights(state["rainclouds"], 1)
   windR = (0,0)
   if thunderstorms:
    windT = self.checkAndWindThunderstorms(thunderstorms)
   if rainclouds:
    windR = self.checkAndWindRainclouds(rainclouds)
   if(math.sqrt(windR[0]*windR[0]+windR[1]*windR[1])>math.sqrt(windT[0]*windT[0]+windT[1]*windT[1]) and windT != (0,0)):
    wind = windT
   else:
    wind = windR
   if wind == (0,0) and not self.onHunt:
    print "No objects of intrest and no Hunt. Doing speed up"
    wind = (self.vy+abs(50-self.vy),abs(50-self.vx))
   if wind != (0,0): 
    if wind[0]>200:
     wind[0]=200
    if wind[0]<-200:
     wind[0]=-200
    if wind[1]>200:
     wind[1]=200
    if wind[1]<-200:
     wind[1]=-200
    self.wind((wind[0]-self.vx)*1.1,(wind[1]-self.vy)*1.1) 
  self.sleep(sleepSeconds)

 def checkAndWindThunderstorms(self, thunderstorms): 
  wind = (0,0)
  actOnCloud = False
  vxSum = 0.0
  vySum = 0.0

  xyratio = 1.0
  for cloud in thunderstorms:
   if cloud["weight"]<-10:
    x,y = self.getXYDistance(cloud)
    vxSum -= x
    vySum -= y
  if vySum != 0.0:
   xyratio = vxSum / vySum
   wind = (vxSum,vySum)
   if wind != (0,0):
    self.onEvade = True
    self.iterationDelay = 5
  elif not self.onHunt:
   actOnCloud = sorted(thunderstorms,key=lambda x: x["weight"], reverse=True)[0]
   if actOnCloud["weight"]>5:
    x,y = self.getXYDistance(actOnCloud)
    wind = (x+actOnCloud["vx"],y+actOnCloud["vy"])
   if wind != (0,0):
    self.onHunt = True
    self.iterationDelay = 5
  return wind

 def checkAndWindRainclouds(self, rainclouds): 
  wind = (0,0)
  actOnCloud = False
  for cloud in rainclouds:
   if cloud["weight"]<-5:
    actOnCloud = cloud
  if actOnCloud:
   x,y = self.getXYDistance(actOnCloud)
   print "Avoid Raincloud", actOnCloud["vapor"], actOnCloud["weight"], "(%s,%s) away" % (x, y)
   wind = (-x+self.vx,-y+self.vy)
  elif not self.onHunt:
   actOnCloud = sorted(rainclouds,key=lambda x: x["weight"], reverse=True)[0]
   if actOnCloud["weight"]>5:
    self.onHunt = True
    self.iterationDelay = 5
    x,y = self.getXYDistance(actOnCloud)
    print "Hunt Raincloud", actOnCloud["vapor"], actOnCloud["weight"], "(%s,%s) away" % (x, y)
    wind = (x+self.vx,y+self.vy)
  return wind

 def getXYDistance(self, cloud):
  x=(cloud["px"]-self.me["px"])
  y=(cloud["py"]-self.me["py"])
  return (x,y)

 def setOwnSpeedAndDirection(self):
  self.vx = self.me["vx"]
  self.vy = self.me["vy"]

 def weightThunderstorms(self, clouds):
  weightedClouds = []
  try:
   for cloud in clouds:
    weight = cloud["vapor"] / self.distance(cloud)
    radarSize = self.radius(self.me)*6
    if not self.canAbsorb(cloud):
     if self.checkProximity(cloud, radarSize):
      weight = -15
     elif self.intersectPath(cloud)<10:
      weight = -50/self.intersectPath(cloud)
     else:
      weight = -1
    else:
     weight = self.warChance(cloud)
    cloud["weight"] = weight
    weightedClouds.append(cloud)
  except TypeError:
   pass
  return weightedClouds

 def getCloudWeights(self, clouds, default_weight):
  weightedClouds = []
  try:
   for cloud in clouds:
    weight = cloud["vapor"] / self.distance(cloud)
    radarSize = self.radius(self.me)*8
    if self.checkProximity(cloud, radarSize):
     if not self.canAbsorb(cloud) and self.distance(cloud)+self.radius(cloud)+self.radius(self.me)>15:
      weight = abs(weight)*(-1)*default_weight
     else:
      weight = self.warChance(cloud)
    elif self.intersectPath(cloud)<10 and not self.canAbsorb(cloud):
      weight = abs(weight)*(-1)*default_weight
    else:
      weight = 0
    cloud["weight"] = weight/100
    if abs(cloud["weight"])>2:
     weightedClouds.append(cloud)
  except TypeError:
   pass
  return weightedClouds

bot = Bot()
while 1:
 bot.main_loop()
