#!/usr/bin/env python

import random
import socket
import sys
import math
import time

class AI:
	def __init__(self, s=None):
		if s is None:
			self.s = socket.socket(
			socket.AF_INET, socket.SOCK_STREAM)
		else:
			self.s = s

	def connect(self, host, port):
		print "Connecting to", host, port
		try:
			self.s.connect((host, port))
		except Exception, e:
			print >>sys.stderr, e
			sys.exit(1)

	def name(self, nick):
		print "Sending name:", nick
		self.s.send("NAME %s" % (nick,))

	def start(self):
		print "Waiting on start from server..."
		while 1:
			ready = self.s.recv(4096)
			if 'START' in ready:
				print "Received START"
				break

	def wind(self, x, y):
		print "Sending WIND", x, y

		try:
			self.s.send('WIND %s %s' % (x,y))
		except socket.error:
			pass
		
		#while 1:
		status = self.s.recv(1024)
		print "status:", status
		if "OK" in status:
			print "WIND OK"
			return True
			#break
		if "IGNORE" in status:
			print "WIND IGNORE"
			return False
			#break
		#'''

	def getState(self):
		#print "Sending GET_STATE"

		try:
			self.s.send('GET_STATE')
		except Exception, e:
			print e #>>sys.stderr, e
			sys.exit(1)

		currentState = self.s.recv(4096)
		raw = currentState.split("\n")
		#raw = raw.rstrip()


		# remove the last \n from END_STATE
		# if not we get: IndexError: list index out of range
		raw = raw[:-1]

		state = {}
		state["rainclouds"] = []
		state["thunderstorms"] = []

		#print 'raw', raw

		'''			if not "END_STATE" in raw:
				print "Missing END_STATE"
				break
			elif not "BEGIN_STATE" in raw[0]:
				print "Missing BEGIN_STATE"
				break
		'''
		for i in raw:
			i = i.rstrip()
			l = i.split()

			if len(l) == 0:
				continue 

			if l[0] == "BEGIN_STATE":
				state["interation"] = int(l[1])

			if l[0] == "YOU":
				state["you"] = int(l[1])

			if l[0] == "THUNDERSTORM":
				state["thunderstorms"].append({
					"px": float(l[1]),
					"py": float(l[2]),
					"vx": float(l[3]),
					"vy": float(l[4]),
					"vapor": float(l[5]),
					})

			if l[0] == "RAINCLOUD":
				state["rainclouds"].append({
					"px": float(l[1]),
					"py": float(l[2]),
					"vx": float(l[3]),
					"vy": float(l[4]),
					"vapor": float(l[5]),
					})

		try:
			if not state.get("you", False):
				state["me"] = state["thunderstorms"][state["you"]]
				del state["thunderstorms"][state["you"]]
			else:
				state["me"] = "None"
		except IndexError, KeyError:
			pass

		self.state = state
		return state

	def sleep(self, sec=0.1):
		time.sleep(sec)


	################################################################################
# SECRET SAUSE!
################################################################################

	def canAbsorb(self, cloud):
		if self.me["vapor"] > cloud["vapor"]:
			return True
		else:
			return False

	def distance(self, cloud):
		return math.sqrt(pow(cloud["px"] - self.me["px"], 2) + pow(cloud["py"] - self.me["py"], 2));

	def radius(self, cloud):
		return math.sqrt(cloud["vapor"])

	def checkCollision(self, cloud, safeBound):
		if self.distance(cloud) < self.radius(self.me) + self.radius(cloud) + safeBound:
			return True
		else:
			return False

	def checkProximity(self, cloud, safeBound):
		if self.distance(cloud) < self.radius(self.me) + self.radius(cloud) + safeBound:
			return True
		else:
			return False

	def evade(self, i):
		print "* Evade!"
		randDirection = random.randint(0,1)
		randWind = random.randint(-10,10)
		strength = 100
		#strength = i["vx"] + i["vy"] + (i["vapor"]*0.1)

		x = self.state["me"]["px"] - i["px"]
		y = self.state["me"]["py"] - i["py"]
		if randDirection == 0:
			print "go left"
			if x < 0:
				y = y + strength
			elif x > 0:
				y = y - strength
			if y < 0:
				x = x - strength
			elif y > 0:
				x = x + strength
			self.wind(x+randWind, y+randWind)
		else:
			print "go right"
			if x < 0:
				y = y - strength
			elif x > 0:
				y = y + strength
			if y < 0:
				x = x + strength
			elif y > 0:
				x = x - strength
			self.wind(x+randWind, y+randWind)

	def chase(self, i):
		print "* Chase!"
		strength=0.5
		x = i["px"] - self.state["me"]["px"] /2
		y = i["py"] - self.state["me"]["py"] /2
		print "vapor loss:", self.windVaporLossXY(x, y)
		self.wind(x, y)

	def windVaporLossXY(self, x, y):
		return math.sqrt(x*x+y*y)

	def windVaporLoss(self, cloud):
		px = cloud["px"]-self.me["px"]
		py = cloud["py"]-self.me["py"]
		return self.windVaporLossXY(px,py)

	def warChance(self, cloud):
		return (self.me["vapor"] - self.windVaporLoss(cloud)) - cloud["vapor"]

	def intersectPath(self, cloud):
		intersect = False
		for i in range(1,20):
			intersectX = abs((self.me["px"]+self.me["vx"]*i - cloud["px"]+cloud["vx"]*i))<(cloud["vapor"]+self.me["vapor"])/2
			intersectY = abs((self.me["py"]+self.me["vy"]*i - cloud["py"]+cloud["vy"]*i))<(cloud["vapor"]+self.me["vapor"])/2
			intersect =  intersectX and intersectY
			if intersect:
				return i
		return intersect 

 
