import java.io.IOException;

public class MyAi extends Client {

    public MyAi() throws IOException, InterruptedException {
        super();
    }

    // Implement your AI here
    // Use these functions to communicate with server:
    //    SetName(name) - Sets your name to appear in the simulator
    //    GetState() - returns the current GameState object
    //    Wind(x, y) - applies a wind in the given direction (returns true if OK, false if IGNORED)
    @Override
    public void RunAi() throws IOException, InterruptedException {
        SetName("SimpleAI");
        
        boolean ChaseThunderstorm = false;
        boolean ThunderstormActive = false;
        int     NumberOfThunderstorms = 0;
        int     NumberOfRainclouds = 0;
        int     LargestThunderstorm = 0;
        int     LargestRaincloud = 0;
        int     BestThunderstormTarget = 0;
        int     BestRaincloudTarget = 0;
        float   WindX = 1;
        float   WindY = 1;
        float   TargetDistanceX = 0;
        float   TargetDistanceY = 0;
        float   VelocityDiffX = 0;
        float   VelocityDiffY = 0;        
        
        while (Connected()) {
            // Poll the game state       
            GameState state = GetState();
            if (state == null) break;
            if (state.Rainclouds.isEmpty() && state.Thunderstorms.isEmpty()) break;

            //  Re-init of values
            ChaseThunderstorm = false;
            ThunderstormActive = false;
            LargestThunderstorm = 0;
            BestThunderstormTarget = 0;
            BestRaincloudTarget = 0;
            NumberOfThunderstorms = state.Thunderstorms.size() - 1;
            NumberOfRainclouds = state.Rainclouds.size();

            
            
            // If there's only rain clouds
            if (NumberOfThunderstorms == 0)
            {
              for(int i=0; i <= (state.Rainclouds.size()-1); i++)   // loop through all rain clouds
              {         
 
                if(state.Rainclouds.get(BestRaincloudTarget).Radius() <= state.Rainclouds.get(i).Radius() && (state.Rainclouds.get(i).Radius() < state.Thunderstorms.get(state.MeIndex).Radius()))    // get the largest rain cloud
                {
                  BestRaincloudTarget = i;
                } 
              }
            }
            
            
            // If there's thunderstorms too            
            if (NumberOfThunderstorms != 0)
            {
              for(int i=0; i <= (state.Rainclouds.size()-1); i++)   // loop through all rain clouds
              {         
                // get the best target rain cloud 
                if(state.Rainclouds.get(BestRaincloudTarget).Radius() <= state.Rainclouds.get(i).Radius() && (state.Rainclouds.get(i).Radius() < state.Thunderstorms.get(state.MeIndex).Radius()))
                {
                  BestRaincloudTarget = i;
                } 
              }             
              
              for(int i=0; i <= (state.Thunderstorms.size()-1); i++)
              {
                if(state.MeIndex != i)
                {

                  // get the largest thunderstorm
                  if(state.Thunderstorms.get(LargestThunderstorm).Radius() <= state.Thunderstorms.get(i).Radius())
                  {                    
                    LargestThunderstorm = i;
                  }                   
                  
                  // get the best target thunderstorm, takes own size into account.
                  if(state.Thunderstorms.get(i).Radius() < state.Thunderstorms.get(state.MeIndex).Radius())
                  {
                    BestThunderstormTarget = i;
                    ChaseThunderstorm = true;
                  } 
                }
              }
            }
            
            
            // Calculate distance
            if (ChaseThunderstorm == false)
            {
              System.out.println("Inside raincloud");
              WindX = (state.Rainclouds.get(BestRaincloudTarget).Position.x - state.Thunderstorms.get(state.MeIndex).Position.x);
              WindY = (state.Rainclouds.get(BestRaincloudTarget).Position.y - state.Thunderstorms.get(state.MeIndex).Position.y);            
            }
            else
            {
              System.out.println("Inside thunderstorm");
              WindX = (state.Thunderstorms.get(BestThunderstormTarget).Position.x - state.Thunderstorms.get(state.MeIndex).Position.x);
              WindY = (state.Thunderstorms.get(BestThunderstormTarget).Position.y - state.Thunderstorms.get(state.MeIndex).Position.y); 
            }
                       
            
            // Output some data
            System.out.println("Amount of thunderstorms = " + NumberOfThunderstorms);            
            System.out.println("Amount of rain clouds = " + NumberOfRainclouds);
            System.out.println("Best thunderstorm target = " + BestThunderstormTarget);              
            System.out.println("My index = " + state.MeIndex);
            System.out.println("Position of best thunderstorm target = " + state.Thunderstorms.get(BestThunderstormTarget).Position.x + ", " + state.Thunderstorms.get(BestThunderstormTarget).Position.y);            
            System.out.println("Best rain cloud target = " + BestRaincloudTarget);              
            System.out.println("Position of best raincloud target = " + state.Rainclouds.get(BestRaincloudTarget).Position.x + ", " + state.Rainclouds.get(BestRaincloudTarget).Position.y);            
            System.out.println("My velocity = " + state.Thunderstorms.get(state.MeIndex).Velocity.x + ", " + state.Thunderstorms.get(state.MeIndex).Velocity.y);
            System.out.println("Target distance = " + TargetDistanceX + ", " + TargetDistanceY); 

 
            // Calculate Target path. Takes current velocity into account.
            while ((float)Math.sqrt((WindX*WindX)+(WindY*WindY)) >= ((float)Math.sqrt(state.Thunderstorms.get(state.MeIndex).Vapor)/2))
            {
              WindX = WindX/(float)1.0001;
              WindY = WindY/(float)1.0001;
            }      

//            if ((float)Math.sqrt((WindX*WindX)+(WindY*WindY)) <= (float)1)
//            {
//              WindX = 1;
//              WindY = 1;
//            }
            
//            // Check if we have too much wind... 
//            while (WindX >= ((float)Math.sqrt(state.Thunderstorms.get(state.MeIndex).Vapor)))
//            {
//                WindX = WindX/(float)10;
//            }
//            while (WindY >= ((float)Math.sqrt(state.Thunderstorms.get(state.MeIndex).Vapor)))
//            {
//                WindY = WindY/(float)10;
//            }                       
            
      
            VelocityDiffX = state.Thunderstorms.get(state.MeIndex).Velocity.x;
            VelocityDiffY = state.Thunderstorms.get(state.MeIndex).Velocity.y;
            WindX = WindX - VelocityDiffX;
            WindY = WindY - VelocityDiffY;  
            
            System.out.println("Wind = " + WindX + ", " + WindY);                
            
            
            // Send wind command, but only when the clouds are of appropriate size.
            if (state.Rainclouds.get(BestRaincloudTarget).Vapor >= (state.Thunderstorms.get(state.MeIndex).Vapor/14))
            {
              Wind(WindX, WindY);
            }
            
            
            // Get Previous states
            for(int i=0; i <= (state.Thunderstorms.size()-1); i++)
            {
              state.Thunderstorms.get(i).LastPosition = state.Thunderstorms.get(i).Position;
              state.Thunderstorms.get(i).LastVelocity = state.Thunderstorms.get(i).Velocity;
              state.Thunderstorms.get(i).LastVapor = state.Thunderstorms.get(i).Vapor;
              state.Thunderstorms.get(i).LastRadius = state.Thunderstorms.get(i).Radius();
            }            
            for(int i=0; i <= (state.Rainclouds.size()-1); i++)
            {
              state.Rainclouds.get(i).LastPosition = state.Rainclouds.get(i).Position;
              state.Rainclouds.get(i).LastVelocity = state.Rainclouds.get(i).Velocity;
              
              state.Rainclouds.get(i).LastVapor = state.Rainclouds.get(i).Vapor;
              state.Rainclouds.get(i).LastRadius = state.Rainclouds.get(i).Radius();
            }            

            Thread.sleep(100);
        }
    }

    public static void main(String[] args) {
        try {
            MyAi ai = new MyAi();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}


