#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec4 extinction;
out vec3 inscatter;
out vec3 lightDir;
out vec3 eyeDir;
out vec2 uv;
out vec2 uv2;

#include <gerstner_wave_model_include.vert>

#include <atmosphere_model_include.vert>

void main()
{
	vec4 pos;
	vec3 t, b, n;
	vec4 wpos = WorldMatrix * vec4(POSITION, 1.0);
	calculateGerstnerVertexTBN(wpos.xz, pos, t, b, n);
	pos.x = POSITION.x;
	pos.y += POSITION.y;
	pos.z = POSITION.z;

	calculateGroundAtmosphere(pos.xyz, n, extinction, inscatter);

	vec3 ld = ViewNormalMatrix * SunDirection;
	lightDir.x = dot(ld, t);
	lightDir.y = dot(ld, b);
	lightDir.z = dot(ld, n);

	vec3 eye = -vec3(ModelViewMatrix * pos);
	eyeDir.x = dot(eye, t);
	eyeDir.y = dot(eye, b);
	eyeDir.z = dot(eye, n);

	uv = TEXCOORD;
	uv2 = pos.xz*(1.0/10.0);

	gl_Position = ModelViewProjectionMatrix * pos; //vec4(POSITION, 1.0);
}
