#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;
uniform float scale;

in vec3 POSITION;
in vec2 TEXCOORD;

out vec3 normal;
out vec3 eyeDir;
out vec3 lightDir;
out vec3 uv_alpha;

#include <gerstner_wave_model_include.vert>

#include <atmosphere_model_include.vert>

void main()
{
	vec4 pos, wpos;
	vec3 n;
	
	wpos = WorldMatrix * vec4(POSITION.xyz*scale, 1.0);

	calculateGerstnerVertex(wpos.xz, pos, n);
	pos.x = POSITION.x * scale;
	pos.y += 0.25;
	pos.z = POSITION.z * scale;

	lightDir = ViewNormalMatrix * SunDirection;
	normal = NormalMatrix * n;
	eyeDir = -vec3(ModelViewMatrix * pos);

	uv_alpha.xy = TEXCOORD;
	uv_alpha.z = min(scale, 1.0);

	gl_Position = ModelViewProjectionMatrix * pos;
}
