#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;

in vec3 gs_params[1]; // radius, energy, 1/mass
in vec3 gs_point[1];

out vec2 uv;
out vec2 alpha_energy;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = tex_offset + (UV); \
	uv.y = uv.y; \
	alpha_energy = ae; \
	gl_Position = ModelViewProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

vec2 animationTilePosition(in float t, in float numWidthTiles, in float numHeightTiles)
{
	float tileIndex = floor( (1.0 - t)*numWidthTiles*numHeightTiles );
	float y = floor(tileIndex/numWidthTiles);
	float x = tileIndex - y*numWidthTiles;
	return vec2(x/numWidthTiles, y/numHeightTiles);
}

void main()
{
	float radius = gs_params[0].x*2.f;
	vec3 XAxis = vec3(ModelViewMatrix[0][0], ModelViewMatrix[1][0], ModelViewMatrix[2][0]);
	vec3 YAxis = vec3(ModelViewMatrix[0][1], ModelViewMatrix[1][1], ModelViewMatrix[2][1]);
	vec3 ZAxis = vec3(ModelViewMatrix[0][2], ModelViewMatrix[1][2], ModelViewMatrix[2][2]);

	if ( radius > 0.0 )
	{
		vec3 p0 = gl_in[0].gl_Position.xyz;
		vec3 p1 = gs_point[0];
		vec3 diff = abs(p1 - p0);
		vec3 axis = XAxis * radius;
		if ( diff.x > diff.y ) axis = YAxis*radius;

		//if ( abs(dot(diff, XAxis)) < abs(dot(diff, YAxis)) ) axis = YAxis * radius;

		vec3 eye_pos = vec3(ModelViewMatrix * vec4(p1, 1.0));
		float dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		vec2 ae = vec2(smoothstep(0.0, 1.0, dist), gs_params[0].y);

		vec3 a = p0.xyz + axis;
		vec3 b = p0.xyz - axis;
		vec3 c = p1 - axis;
		vec3 d = p1 + axis;
		
		vec2 tex_offset = animationTilePosition(gs_params[0].z, 4.0, 4.0);

		EMIT_VERTEX(a, vec2(0.25, 0.25));
		EMIT_VERTEX(b, vec2(0.0, 0.25));
		EMIT_VERTEX(d, vec2(0.25, 0.0));
		EMIT_VERTEX(c, vec2(0.0, 0.0));

		EndPrimitive();
	}
}
