#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 WorldMatrix;
uniform mat3 WorldNormalMatrix;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec4 extinction;
out vec3 inscatter;
out vec2 uv;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 offset = vec3(0.0);
	offset.x = sin(time + POSITION.z*1.57)*TEXCOORD.y*0.1;
	offset.z = cos(time + POSITION.x*1.57)*TEXCOORD.y*0.1;

	vec3 pos = vec3(WorldMatrix * vec4(POSITION + offset, 1.0));
	vec3 n = normalize(WorldNormalMatrix * NORMAL);
	calculateGroundAtmosphere(pos, n, extinction, inscatter);

	uv = TEXCOORD;

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION + offset, 1.0);
}
