#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;
uniform float time;

in vec3 gs_axis[1];
in vec3 gs_params[1]; // radius, energy, 1/mass

out vec2 uv;
out float alpha;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#include <matrix_include.vert>

#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	alpha = al; \
	gl_Position = ModelViewProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	float radius = gs_params[0].x;

	if ( radius > 0.0 )
	{
		vec3 ZAxis = vec3(ModelViewMatrix[0][2], ModelViewMatrix[1][2], ModelViewMatrix[2][2]);
		mat3 mr;
		rotate_around_axis(ZAxis, gs_params[0].y, mr);

		vec3 XAxis = mr * vec3(ModelViewMatrix[0][0], ModelViewMatrix[1][0], ModelViewMatrix[2][0]);
		vec3 YAxis = mr * vec3(ModelViewMatrix[0][1], ModelViewMatrix[1][1], ModelViewMatrix[2][1]);

		vec4 pos = gl_in[0].gl_Position;
		vec3 eye_pos = vec3(ModelViewMatrix * pos);
		float dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		float al = smoothstep(0.0, 1.0, dist);

		vec3 a = pos.xyz + (XAxis + YAxis)*radius;
		vec3 b = pos.xyz + (YAxis - XAxis)*radius;
		vec3 c = pos.xyz + (-XAxis - YAxis)*radius;
		vec3 d = pos.xyz + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));

		EndPrimitive();
	}
}
