#version 330 core

uniform sampler2D diffuse;
uniform sampler1D color_lut;

in vec4 extinction;
in vec3 inscatter;
in vec3 eyeDir;
in vec3 lightDir;
in vec3 normal;
in vec2 uv;
in float alpha;

layout (location = 0) out vec4 frag_color;

#include <atmosphere_model_include.vert>

#include <shading_models/oren_nayar_model_include.frag>

void main()
{
	vec3 n = normalize(normal) * (gl_FrontFacing ? -1.0 : 1.0);
	vec3 ed = normalize(eyeDir);
	vec3 ld = normalize(lightDir);
#if 1
	vec3 terms = calculate_oren_nayar_model_abs(n, ld, ed, 0.3, 8.0);
	vec4 diff = texture(diffuse, uv) * texture(color_lut, terms.x);
	vec4 color = diff*terms.x + diff*terms.y;

	float a = alpha;//*color.a;
#else
	vec4 color = texture(diffuse, uv) * texture(color_lut, alpha);
	float a = alpha*color.a;
#endif

	lightGroundAtmosphere(color, extinction, inscatter);

	frag_color = color*a;
}
