#version 330 core

uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewProjectionMatrix;
uniform float time;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec2 uv;
out vec2 alpha_energy;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;


#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	alpha_energy = ae; \
	gl_Position = ModelViewProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	vec3 XAxis = vec3(ModelViewMatrix[0][0], ModelViewMatrix[1][0], ModelViewMatrix[2][0]);
	vec3 YAxis = vec3(ModelViewMatrix[0][1], ModelViewMatrix[1][1], ModelViewMatrix[2][1]);

	float radius = gs_params[0].x;

	if ( radius > 0.0 )
	{
		vec4 pos = gl_in[0].gl_Position;

		vec3 eye_pos = vec3(ModelViewMatrix * pos);
		float eye_dist = dot(vec3(0.0, 0.0, -1.0), eye_pos ) - 1.0;
		vec2 ae = vec2(smoothstep(0.0, 1.0, eye_dist), gs_params[0].y);

		float r = abs(cos(pos.x + pos.y + pos.z))*0.75;
		float angle = time + pos.x*pos.z;
		pos.x += cos(angle)*r;
		pos.y += sin(angle)*r;

		vec3 a = pos.xyz + (XAxis + YAxis)*radius;
		vec3 b = pos.xyz + (YAxis - XAxis)*radius;
		vec3 c = pos.xyz + (-XAxis - YAxis)*radius;
		vec3 d = pos.xyz + (XAxis - YAxis)*radius;

		EMIT_VERTEX(a, vec2(1.0, 0.0));
		EMIT_VERTEX(b, vec2(0.0, 0.0));
		EMIT_VERTEX(d, vec2(1.0, 1.0));
		EMIT_VERTEX(c, vec2(0.0, 1.0));

		EndPrimitive();
	}
}
