
vec3 calculate_blinn_phong_model(in vec3 n, in vec3 l, in vec3 e, in float specularPower)
{
	vec3 hv = normalize(l + e);
	float diffTerm = max(dot(n, l), 0.0);
	float specTerm = pow(max(dot(n, hv), 0.0), specularPower)*diffTerm;
	return vec3(diffTerm, specTerm, 1.0);
}

