#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 WorldNormalMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;
in vec4 TANGENT;

out vec2 uv;
out vec2 uv2;
out vec4 extinction;
out vec3 inscatter;
out vec3 eyeDir;
out vec3 lightDir;
out vec3 normal;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 pos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	vec3 n = normalize(WorldNormalMatrix * NORMAL);

	calculateGroundAtmosphere(pos, n, extinction, inscatter);

	uv = TEXCOORD;

	//uv2 = vec2(0.5) + (POSITION.xz - vec2(0.0822725, 0.1526957)) * vec2(1.0/29.4283, 1.0/28.2864);
	uv2 = uv*0.25;//POSITION.xz*vec2(1.0/8.0);

	//
	n = normalize(NormalMatrix * NORMAL);
	vec3 t = normalize(NormalMatrix * TANGENT.xyz);
	vec3 b = normalize(cross(t, n));// * TANGENT.w);

	vec3 ld = ViewNormalMatrix * SunDirection;
	lightDir.x = dot(ld, t);
	lightDir.y = dot(ld, b);
	lightDir.z = dot(ld, n);

	vec3 eye = -vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	eyeDir.x = dot(eye, t);
	eyeDir.y = dot(eye, b);
	eyeDir.z = dot(eye, n);

	normal = n;

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
