
float soft_shadow(in sampler2DShadow depth, in vec4 proj_pos, in float texel_size )
{
	if ( proj_pos.w < 0.0 ) return 1.0;

	//const float texel_size = 16.0 / 1024.0;
	float shadow_term = textureProj(depth, proj_pos);
	shadow_term += textureProj(depth, proj_pos + vec4( -texel_size, 0.0, 0.0, 0.0));
	shadow_term += textureProj(depth, proj_pos + vec4( texel_size, 0.0, 0.0, 0.0));
	shadow_term += textureProj(depth, proj_pos + vec4( 0.0, -texel_size, 0.0, 0.0));
	shadow_term += textureProj(depth, proj_pos + vec4( 0.0, texel_size, 0.0, 0.0));
	shadow_term += textureProj(depth, proj_pos + vec4( -texel_size, -texel_size, 0.0, 0.0));
	shadow_term += textureProj(depth, proj_pos + vec4( texel_size, -texel_size, 0.0, 0.0));
	shadow_term += textureProj(depth, proj_pos + vec4( -texel_size, texel_size, 0.0, 0.0));
	shadow_term += textureProj(depth, proj_pos + vec4( texel_size, texel_size, 0.0, 0.0));
	return shadow_term / 9.0;
}


float hard_shadow(in sampler2DShadow depth, in vec4 proj_pos )
{
	if ( proj_pos.w < 0.0 ) return 1.0;
	return textureProj(depth, proj_pos);
}

