uniform vec4      CameraRange; // near, far, (far - near), (-near*far)
uniform vec4      DOFParams;   // aperture, FocalLength, PlaneInFocus, PlaneInFocus - FocalLength

float circleOfConfusion(in float z)
{
	float obj_dist = CameraRange.w / (z*CameraRange.z - CameraRange.y);
	float coc = abs( DOFParams.x * (DOFParams.y * (obj_dist - DOFParams.z)) / (obj_dist * DOFParams.w) );
	
	return clamp(coc, 0.0, 1.0);
}
