#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2D bumpmap;
uniform sampler2D heightmap;

in vec2 pos_zw;
in vec3 normal;
in vec3 ec_pos;
in vec2 uv;
in float dist;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

#include <geometry_include.frag>
#include <tangentspace_include.frag>

void main()
{
	vec3 t, b;
	per_fragment_tangent_space(ec_pos, uv, t, b);

	//float height = (texture2D(bumpmap, uv).y*0.04 - 0.02)*4.0;
	float height = (texture(heightmap, uv).y*0.04 - 0.02)*3.5;
	//float height = texture2D(specular, uv).x*((texture2D(bumpmap, uv).y*0.04 - 0.02)*16.0);
	//height *= 1.0 / ec_pos.z;
	vec2 tex_coord = uv + normalize(-ec_pos).xy*height;

	vec3 bump = normalize(texture(bumpmap, tex_coord).xyz*2.0 - vec3(1.0));

	mat3 mr = mat3(t, b, normalize(normal));
	vec3 n = mr * bump;

	diffuse_specular.rgb = texture(diffuse, tex_coord).rgb;
	diffuse_specular.a = texture(specular, tex_coord).r;

	normal_depth.xyz = normalize(n);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
