#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;
uniform vec2 CloudsOffset;

in vec3 POSITION;

out vec2 uv;
out vec2 uv_noise;
out vec4 normal;
out vec4 extinction;
out vec3 inscatter;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 n = normalize(-POSITION);
	calculateCloudAtmosphere(POSITION*2.0, n, extinction, inscatter);

	//
	//normal = NormalMatrix * n;
	normal.xyz = n;
	normal.w = smoothstep(0.0, 1.0, POSITION.y*0.01);
	uv = (POSITION.xz / 250.0) + CloudsOffset;
	uv_noise = sin(CloudsOffset) + (uv.yx + CloudsOffset.yx)*0.5;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
