#version 330 core

uniform sampler2D clouds;
uniform sampler2D noise;

in vec4 normal;
in vec2 uv;
in vec2 uv_noise;
in vec4 extinction;
in vec3 inscatter;

layout (location = 0) out vec4 frag_color;

#include <atmosphere_model_include.vert>

void main()
{
	const vec3 light = vec3(1.0);
	const vec3 dark = vec3(0.75);

	float NdotL = max(dot(normalize(-normal.xyz), SunDirection), 0.0);
	float depth = texture(clouds, uv).r*texture(noise, uv_noise).r;

	float shade = 1.0 - smoothstep(0.0, 0.75, depth);//*0.5;
	shade *= (texture(noise, uv*2.0).r + texture(noise, uv_noise*2.0).r)*0.75 + 0.25;

	vec4 color = vec4(mix(dark,light,shade)*shade*NdotL, smoothstep(0.0, 0.15, depth)*0.8);
	float alpha = color.a*normal.w;
	lightCloudAtmosphere(color, extinction, inscatter);

	frag_color.rgb = color.rgb;
	frag_color.a = alpha;
}
