#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 WorldNormalMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;
uniform mat4 TextureMatrix;

in vec3 POSITION;
in vec3 NORMAL;

out vec2 uv;
out vec2 mask_uv;
out vec4 extinction;
out vec3 inscatter;
out vec3 eyeDir;
out vec3 lightDir;
out vec3 normal;
out vec4 shadow_coord;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 pos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	vec3 n = normalize(WorldNormalMatrix * NORMAL);

	calculateGroundAtmosphere(pos, n, extinction, inscatter);

	vec2 axis = abs(normalize(NORMAL.xz));

	vec2 uv_pos = POSITION.xy;
	if ( axis.x > axis.y )
	{
		uv_pos = POSITION.zy;
	}

	uv = uv_pos*0.5;
	mask_uv = POSITION.xy*0.125;

	lightDir = ViewNormalMatrix * SunDirection;
	eyeDir = -vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	normal = NormalMatrix * NORMAL;

	shadow_coord = TextureMatrix * WorldMatrix * vec4(POSITION, 1.0);
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
