#version 330 core

uniform sampler2D alphamap;
uniform sampler2D diffuse;
uniform sampler2D specular;
uniform sampler2DShadow depth;
uniform samplerCube env;
uniform float damage;

in vec2 uv;
in vec2 mask_uv;
in vec4 extinction;
in vec3 inscatter;
in vec3 eyeDir;
in vec3 lightDir;
in vec3 normal;
in vec4 shadow_coord;

layout (location = 0) out vec4 frag_color;

#include <atmosphere_model_include.vert>

#include <shading_models/oren_nayar_model_include.frag>

#include <forward/shadows_include.frag>


void main()
{
	float alpha = texture(alphamap, mask_uv).r;
	if ( alpha < damage ) discard;
	float diff_mix = 1.0 - smoothstep(0.0, 0.3, alpha-damage);
	float white_mix = 1.0 - smoothstep(0.0, 0.1, alpha-damage);

	vec3 ld = normalize(lightDir);
	vec3 ed = normalize(eyeDir);
	vec3 n = normalize(normal);

	vec3 terms = calculate_oren_nayar_model(n, ld, ed, 0.0, 2.0);

	//vec4 diff = /*texture(diffuse, uv_pos.xz*0.5) +*/ texture(env, n)*2.0;
	vec4 diff = mix(texture(env, n)*2.0, texture(diffuse, uv), diff_mix);
	vec4 spec = texture(specular, uv)*4.0;
	vec4 color = diff*terms.x + spec*terms.y + diff*0.1;

	color *= soft_shadow(depth, shadow_coord, 16.0/1024.0)*0.25 + 0.75;

	lightGroundAtmosphere(color, extinction, inscatter);
	
	frag_color = mix(color, vec4(1.0), white_mix);
}
