#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 WorldNormalMatrix;
uniform mat3 NormalMatrix;
uniform mat3 ViewNormalMatrix;
uniform mat4 TextureMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec4 TANGENT;
in vec2 TEXCOORD;

out vec2 uv;
out vec4 extinction;
out vec3 inscatter;
out vec3 eyeDir;
out vec3 lightDir;
out vec4 shadow_coord;

#include <atmosphere_model_include.vert>

void main()
{
	vec3 pos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	vec3 n = normalize(WorldNormalMatrix * NORMAL);

	calculateGroundAtmosphere(pos, n, extinction, inscatter);

	uv = TEXCOORD;

	n = normalize(NormalMatrix * NORMAL);
	vec3 t = normalize(NormalMatrix * TANGENT.xyz);
	vec3 b = normalize(cross(t, n));// * TANGENT.w);

	vec3 ld = ViewNormalMatrix * SunDirection;
	lightDir.x = dot(ld, t);
	lightDir.y = dot(ld, b);
	lightDir.z = dot(ld, n);

	vec3 eye = -vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	eyeDir.x = dot(eye, t);
	eyeDir.y = dot(eye, b);
	eyeDir.z = dot(eye, n);

	shadow_coord = TextureMatrix * WorldMatrix * vec4(POSITION, 1.0);

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
