#version 330 core

uniform sampler2D particle;
uniform sampler2D bumpmap;

in vec3 eyeDir;
in vec2 uv;
in float alpha_fade;

layout (location = 0) out vec4 frag_color;

#include <shading_models/oren_nayar_model_include.frag>

void main()
{
	vec4 p = texture(bumpmap, uv);
	if ( p.a < 0.05 ) discard;

	vec3 ld = vec3(0.0, 0.0, 1.0);
	vec3 ed = normalize(eyeDir);
	vec3 n = normalize(p.xyz*2.0 - vec3(1.0));

	vec3 terms = calculate_oren_nayar_model(n, ld, ed, 0.0, 16.0);
	vec4 diff = texture(particle, uv);
	vec4 color = diff*terms.x + diff*terms.y;
	color.a = terms.x*p.a*alpha_fade;
	frag_color = color;
}
