#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 WorldMatrix;

in vec3 POSITION;
in vec2 TEXCOORD;

out vec2 uv;
out float alpha;

void main()
{
	vec3 pos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	alpha = smoothstep(0.0, 0.6, pos.y);
	uv = TEXCOORD;
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
