#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 TextureMatrix;
uniform samplerBuffer instanceData;
uniform vec3 distortParams; // // freq, time, amount

in vec3 POSITION;
in vec2 TEXCOORD;

out vec2 uv;
out vec4 shadow_coord;

vec3 distort_pos(in vec3 pos)
{
	vec3 offs;
	offs.x = (sin(pos.z*3.14*distortParams.x + 3.14*distortParams.y)*2.0 - 1.0)*distortParams.z;
	offs.y = 0.0;
	offs.z = (sin(pos.x*3.14*distortParams.x + 3.14*distortParams.y)*2.0 - 1.0)*distortParams.z;
	return pos + offs;
}

void main()
{
	mat4 m;
	m[0] = texelFetch(instanceData, gl_InstanceID*4 + 0);
	m[1] = texelFetch(instanceData, gl_InstanceID*4 + 1);
	m[2] = texelFetch(instanceData, gl_InstanceID*4 + 2);
	m[3] = texelFetch(instanceData, gl_InstanceID*4 + 3);

	vec4 pos = m * vec4(distort_pos(POSITION), 1.0);

	uv = TEXCOORD;
	shadow_coord = TextureMatrix * pos;
	gl_Position = ModelViewProjectionMatrix * pos;
}
