#version 330 core

uniform sampler2D diffuse;
uniform vec3 distortParams; // // freq, time, amount


in vec2 uv;
in vec2 alpha_energy;

layout (location = 0) out vec4 frag_color;

vec2 distort_uv(in vec2 uv)
{
	vec2 offs;
	offs.x = (sin(uv.y*3.14*distortParams.x + 3.14*distortParams.y)*2.0 - 1.0)*distortParams.z;
	offs.y = (sin(uv.x*3.14*distortParams.x + 3.14*distortParams.y)*2.0 - 1.0)*distortParams.z;
	return uv + offs;
}

void main()
{
	vec4 c = texture(diffuse, distort_uv(uv)).rrrr  * alpha_energy.x;
	if ( c.a < 0.25 ) discard;
	frag_color = c*alpha_energy.y;
}
