float Black;
float White;
float Contrast;

float4 PositionRect;
float4 TexCoordRect;

float2 Ratio;

Texture2D Tex;
SamplerState StdSampler;

struct VSInput
{
	float2 Position: POSITION;
};

struct VSOutput
{
	float4 Position: SV_Position;
	float2 TexCoord: TEXCOORD;
};

VSOutput vsMain(VSInput Input)
{
	VSOutput Output;
	Output.Position = float4((Input.Position * PositionRect.zw + PositionRect.xy) * Ratio, 0, 1);
	Output.TexCoord = Input.Position * TexCoordRect.zw * float2(1,-1) + TexCoordRect.xy;
	return Output;
}

Texture2D Overlay, Glow;

float4 psMain(VSOutput input): SV_TARGET
{
	float4 c = pow((Tex.Sample(StdSampler, input.TexCoord) + Glow.Sample(StdSampler, input.TexCoord)) * (1.0 + Contrast), 1.0 + Contrast);
	float4 o = Overlay.Sample(StdSampler, input.TexCoord);

	c *= o;
	c *= (1.0 - Black);
	c += White;

	return float4(c.xyz, 1.0);
}
