
struct PSOutput
{
	float4 ColorSpec: SV_Target0;
	float4 ViewNormal: SV_Target1;
	float Depth: SV_Target2;
};

Texture2D CubeTex;
SamplerState TexSampler;

PSOutput psMain(GSOutput Input)
{
	PSOutput Output;
	float t = CubeTex.Sample(TexSampler, Input.TexCoord).x;
	Output.ColorSpec = float4(Input.Color.xyz*0.65, 0.5+t*0.8); 
	Output.ViewNormal.xyz = normalize(Input.ViewNormal);
	Output.Depth = length(Input.ViewPosition);
	return Output;
}


