
#define depthNear 50
#define depthFar 300.0

float2 tcFromFace(float3 v, float3 n)
{
	float2 tc = v.xy;
	if (abs(n.y) > abs(n.z)) tc = v.xz;
	if (abs(n.x) > abs(n.y)) tc = v.yz;
	return tc;
}

float2 packIntoByte2(float d, float dmin, float dmax)
{
	float depth = 65535.0 * max(0, min(1, (d - dmin) / (dmax-dmin)));

	float depthmsb = floor(depth/255.0);
	float depthlsb = depth - depthmsb*255.0;
	return float2(depthmsb, depthlsb) / 255.0;
}

float unpackFromByte2(float2 v, float dmin, float dmax)
{
	return dmin + (dmax-dmin)*(v.x+v.y/255.0);
}
