
float4 PositionRect;
float4 TexCoordRect;

Texture2D Tex;
SamplerState StdSampler;

struct VSInput
{
	float2 Position: POSITION;
};

struct VSOutput
{
	float4 Position: SV_Position;
	float2 TexCoord: TEXCOORD;
};

float Scale;
float4 Color;

VSOutput vsMain(VSInput Input)
{
	VSOutput Output;
	Output.Position = float4(Input.Position * PositionRect.zw + PositionRect.xy, 0, 1);
	Output.TexCoord = Input.Position * TexCoordRect.zw * float2(1,-1) + TexCoordRect.xy;
	Output.Position.xy *= Scale;
	return Output;
}

float4 psMain(VSOutput Input): SV_Target
{
	return Tex.Sample(StdSampler, Input.TexCoord) * Color;
}