import processing.core.*; 
import processing.xml.*; 

import krister.Ess.*; 
import processing.opengl.*; 
import codeanticode.glgraphics.*; 

import javazoom.spi.*; 
import org.tritonus.share.sampled.convert.*; 
import javazoom.jl.player.advanced.*; 
import javazoom.spi.mpeg.sampled.convert.*; 
import org.tritonus.share.*; 
import org.tritonus.share.sampled.*; 
import org.tritonus.share.midi.*; 
import javazoom.spi.mpeg.sampled.file.*; 
import javazoom.spi.mpeg.sampled.file.tag.*; 
import javazoom.jl.converter.*; 
import javazoom.jl.player.*; 
import org.tritonus.share.sampled.file.*; 
import org.tritonus.share.sampled.mixer.*; 
import javazoom.jl.decoder.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class project extends PApplet {





String[] book;


float pagestart;
int page = 0;

PFont font;

GLGraphics renderer;
AudioChannel myChannel;
FFT myFFT;
float myDamp=.1f;
float maxLimit,minLimit;
float limitDiff;


float[] gridPos = new float[160];
float aw = 0;

float dt = 0;

float framestart = 0;
float frameend = 0;

int ms = 0;
int bufferSize;
int bufferDuration;

GLGraphicsOffScreen canvas;
GLTextureFilter fisheye;
GLTextureFilter post;

GLTexture tex;
GLTexture tex2;

public void setup() {
  size(800, 600, GLConstants.GLGRAPHICS);
  frameRate(120);

  canvas = new GLGraphicsOffScreen(this, width, height, true, 4);
  tex = new GLTexture(this);
  tex2 = new GLTexture(this);
  
  fisheye = new GLTextureFilter(this, "FishEye.xml");
  post = new GLTextureFilter(this, "post.xml");
  

  for (int i = 0;i < gridPos.length; i++)
    gridPos[i] = width+i*(aw*1.1f)+cos(i)*aw;
    
  font = loadFont("font.vlw");
  textFont(font,48);
   
  book = new String[6];
    
  ///////////////////////////////////////////////////////////////////////////
  book[0] = "";
  book[0] += "                                                               \n";
  book[0] += "                     \n  ";
  book[0] += "                                              One life left    \n";
  book[0] += "       ???     \n";
  book[0] += "Only one wish; to be left alone, to be left to my own devices. \n";
  book[0] += "                                                               \n";
  book[0] += "                                          a story              \n";
  book[0] += "                      \n";


  book[1] = "";
  book[1] += "                                                               \n";
  book[1] += "You see, I'm just a regular guy, you know? I never did want no \n";
  book[1] += "harm to come to anyone, definitely not, no sirree. What we have\n";
  book[1] += "once again had is the happy accident that so befells even the  \n";
  book[1] += "most common of creatures; the Man.                             \n";
  book[1] += "   Just another day, starting up my Volvo like I've so done a  \n";
  book[1] += "    thousand times before. Keys from pocket to hand, jingle the\n";
  book[1] += "     car key; that familiar plastic shape finds itself again   \n";
  book[1] += "    in the oh-so-familiar position, just like it did those     \n";
  book[1] += "     thousand times before on those thousand identical days.   \n";
  book[1] += "      I inserted the key in the ignition, waiting for a bang.  \n";
  book[1] += "        None came, as usual. These fantasies have really got to\n";
  book[1] += "          stop, they said. I don't really understand what they \n";
  book[1] += "          miss about the clearly iterated analysis of my enemy.\n";
  book[1] += "It's not like I'm ignorant or anything, it's insulting (to say \n";
  book[1] += "     the least.)                                               \n";

  book[2] = "";
  book[2] += "    The gardening boy asked me for a ride to the arcades again.\n";
  book[2] += "                                              I declined.\n";
  book[2] += "                        That homosexual little cocksucker can\n";
  book[2] += "                                      find his own ride for\n";
  book[2] += "                                        his own little faggot\n";
  book[2] += "                                    outings. I did smile too\n";
  book[2] += "                                                        widely.\n";
  book[2] += "                                                               \n";
  book[2] += "       God help these fucking sinners and\n";
  book[2] += "       whoremongers and\n";
  book[2] += "       gambling addicts and\n";
  book[2] += "       cokeheads and\n";
  book[2] += "       glue-sniffing pederasts.\n";
  book[2] += "                For all I care, they can\n";
  book[2] += "                sodomize each other with\n";
  book[2] += "                their atrophied little dicks in Hades.               \n";

  book[3] = "";
  book[3] += "   I wonder when they will all stop fucking with me; it's not  \n";
  book[3] += " like I deserve this sub-human treatment from them. What did I do?\n";
  book[3] += "  Why should I be the one to get picked on, the underdog, the  \n";
  book[3] += "  eternal loser, the butt of jokes, the punchline and a margin \n";
  book[3] += "   in a cheap Tijuana porno book.                              \n";
  book[3] += "                                I must have one of those faces.\n";
  book[3] += "                                                               \n";
  book[3] += "      You know.                                                \n";

    book[4] = "";
    book[4] += " Another moronic, derivative, banal, dull and condescending    \n";
    book[4] += " narrative is born. The audience watches and finds no substance\n";
    book[4] += " in the manic drivel of a hack writer stuck on cliches and     \n";
    book[4] += " impossibly megalomanical ramblings.                           \n";
    book[4] += "                   *takes a bow*                               \n";
    
    
  // start soundsystem and load song

  Ess.start(this);

  myChannel=new AudioChannel("song.mp3");
  myChannel.sampleRate(44100,true);
  
  // set up our FFT
  myFFT=new FFT(512);
  myFFT.equalizer(true);
  
  minLimit=.005f;
  maxLimit=.05f;
  myFFT.limits(minLimit,maxLimit);

  myFFT.damp(myDamp);
  limitDiff=maxLimit-minLimit;

// play song and start rendering

  myChannel.play();

}


public void drawText(float t) {
  
  String curs = "";
  
  String helper = str(t);
  
  
  if (PApplet.parseFloat(helper.substring(helper.length()-3,helper.length())) > 500) curs = "_";
    
  fill(64);
  float textpos = (t*17)-pagestart;
  if (textpos > book[page].length()) {
    textpos = 0;
    pagestart = t*17;
    page++;
    if (page >= 5)  {
      exit();
      page = 0;
    }
    if (page > book.length) page = 0;
    textpos = (t*17)-pagestart;
  }
 
  
  if (textpos < 0) textpos = 0;
      
  float offx = sin(t+random(1,3))*2;
  float offy = cos(t+random(1,2))*2;
  text(book[page].substring(0,(int)(textpos))+curs, 64+offx,44+offy, 10.0f);

  fill(192);
  offx = sin(t+random(1,3))*2;
  offy = cos(t+random(1,2))*2;
  text(book[page].substring(0,(int)(textpos))+curs, 64,44+offy, 11.0f);

}

public void draw() {
  int songms = myChannel.ms(myChannel.cue);

  // quit at song end  
  if (songms >= myChannel.duration) exit();
  
  ms = millis();
  framestart = millis();

  myFFT.getSpectrum(myChannel);

  float aud=max(0,(myFFT.max-.005f)/limitDiff);
  aud = aud * 100;
  
  float t = millis() / 1000.0f;
  
  // -------------------------------- render effects
    
  canvas.beginDraw();
  if (page == 0) canvas.tint(t,cos(t*0.1f)*255,sin(t*0.1f)*255, 255);
  else if (page == 1) {
    canvas.tint(255-aud,sin(t*0.5f)*255, cos(t*0.8f)*255, 192);
  }
  else if (page == 2) {
    canvas.tint(192,sin(t*0.7f)*255, sin(t*0.75f)*255, 164);
  }
  else if (page == 3) {
    canvas.tint(255-aud,cos(t*0.75f)*255, cos(t*0.8f)*255, 192);
  }
  else if (page == 4) {
    canvas.tint(192,sin(t*0.4f)*255, sin(t*0.8f)*255, 192);
  }

  canvas.rotate(cos(t)*0.0001f);
  canvas.image(tex,0,0,width,height);
  
  canvas.tint(255);

  canvas.lights();
  
    for (float i = 0; i < 360*2; i+=2) {
  canvas.stroke(i*0.6f+cos(millis()*0.0002f)*64,192);

    canvas.pushMatrix();
    canvas.translate(width/2,height/2);
    canvas.rotate(i);
    canvas.translate(-width/2,-height/2);

    canvas.line(width/2,height/2+cos(millis()*0.001f*i*0.001f)*height/3,width/2+cos(i+millis()*0.001f)*(sin(millis()*0.0001f)*width),height/2+atan(i+millis()*0.001f)*(cos(millis()*0.0001f)*height));
    canvas.popMatrix();
  }

    
  canvas.endDraw(); 

  canvas.beginDraw();

  
  canvas.endDraw();

  fisheye.setParameterValue("aperture", cos(t*0.1f));
  post.setParameterValue("time", t);

  fisheye.apply(canvas.getTexture(), tex);

  post.apply(tex, tex2);
  

  background(255);
    tint(192);

  image(tex2, 0, 0, width, height);  
  tint(255,128);
  image(canvas.getTexture(), 0, 0, width, height);  

  drawText(t);

  

  frameend = millis();

  dt = frameend-framestart;

}

public void stop() {
  Ess.stop();
  super.stop();
}
  static public void main(String args[]) {
    PApplet.main(new String[] { "--present", "--bgcolor=#666666", "--hide-stop", "project" });
  }
}
