/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLTextureGrid;
import codeanticode.glgraphics.GLTexturedPoint;
import javax.media.opengl.GL;
import processing.xml.XMLElement;

public class GLTextureGridDirect
extends GLTextureGrid {
    protected int resX;
    protected int resY;
    protected int numLayers;
    protected float[] gridDX;
    protected float[] gridDY;

    public GLTextureGridDirect(GL gL) {
        super(gL);
        this.initGrid();
    }

    public GLTextureGridDirect(GL gL, XMLElement xMLElement) {
        super(gL);
        this.initGrid(xMLElement);
    }

    public void render(int n, int n2, int n3, int n4, int n5) {
        GLTexturedPoint gLTexturedPoint = new GLTexturedPoint();
        GLTexturedPoint gLTexturedPoint2 = new GLTexturedPoint();
        for (int i = 0; i < this.resY - 1; ++i) {
            this.gl.glBegin(8);
            for (int j = 0; j < this.resX; ++j) {
                this.getPoint(0, j, i, gLTexturedPoint);
                this.getPoint(0, j, i + 1, gLTexturedPoint2);
                gLTexturedPoint.scaleCoords(n3, n4);
                gLTexturedPoint2.scaleCoords(n3, n4);
                this.setTexCoord(j, i, n5);
                this.gl.glVertex2f(gLTexturedPoint.x, gLTexturedPoint.y);
                this.setTexCoord(j, i + 1, n5);
                this.gl.glVertex2f(gLTexturedPoint2.x, gLTexturedPoint2.y);
            }
            this.gl.glEnd();
        }
    }

    private void getPoint(int n, int n2, int n3, GLTexturedPoint gLTexturedPoint) {
        if (n < this.numLayers) {
            gLTexturedPoint.s[0] = this.gridDX[n];
            gLTexturedPoint.t[0] = this.gridDY[n];
        } else {
            gLTexturedPoint.s[0] = this.gridDX[0];
            gLTexturedPoint.t[0] = this.gridDY[0];
        }
        gLTexturedPoint.x = (float)n2 * gLTexturedPoint.s[0];
        gLTexturedPoint.y = (float)n3 * gLTexturedPoint.t[0];
    }

    protected void setTexCoord(int n, int n2, int n3) {
        GLTexturedPoint gLTexturedPoint = new GLTexturedPoint();
        for (int i = 1; i <= n3; ++i) {
            this.getPoint(i, n, n2, gLTexturedPoint);
            this.gl.glMultiTexCoord2f(33984 + i - 1, gLTexturedPoint.x, gLTexturedPoint.y);
        }
    }

    protected void initGrid() {
        this.numLayers = 1;
        this.gridDX = new float[this.numLayers];
        this.gridDY = new float[this.numLayers];
        this.resY = 2;
        this.resX = 2;
        this.gridDX[0] = 1.0f / (float)(this.resX - 1);
        this.gridDY[0] = 1.0f / (float)(this.resY - 1);
    }

    protected void initGrid(XMLElement xMLElement) {
        int n = xMLElement.getChildCount();
        this.numLayers = n == 1 ? 1 : n - 1;
        this.gridDX = new float[this.numLayers];
        this.gridDY = new float[this.numLayers];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (string.equals("resolution")) {
                this.resX = xMLElement2.getIntAttribute("nx");
                this.resY = xMLElement2.getIntAttribute("ny");
                continue;
            }
            if (!string.equals("spacing")) continue;
            this.gridDX[n2] = xMLElement2.getFloatAttribute("dx");
            this.gridDY[n2] = xMLElement2.getFloatAttribute("dy");
            ++n2;
        }
        if (n == 1) {
            this.gridDX[0] = 1.0f / (float)(this.resX - 1);
            this.gridDY[0] = 1.0f / (float)(this.resY - 1);
        }
    }
}

