/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLShader;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CGprogram;
import com.sun.opengl.cg.CgGL;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import processing.core.PApplet;

public class GLCgShader
extends GLShader {
    protected boolean vertexShaderEnabled;
    protected boolean fragmentShaderEnabled;
    protected boolean geometryShaderEnabled;
    protected CGcontext context = (CGcontext)GLState.createCGResource(6);
    protected int vertexProfile;
    protected int fragmentProfile;
    protected int geometryProfile;
    protected CGprogram currProgram;
    protected CGprogram vertexProgram;
    protected CGprogram fragmentProgram;
    protected CGprogram geometryProgram;
    protected boolean initialized;

    public GLCgShader(PApplet pApplet) {
        super(pApplet);
        CgGL.cgGLRegisterStates((CGcontext)this.context);
        CgGL.cgGLSetManageTextureParameters((CGcontext)this.context, (boolean)true);
        this.vertexShaderEnabled = false;
        this.fragmentShaderEnabled = false;
        this.geometryShaderEnabled = false;
        this.vertexProgram = null;
        this.fragmentProgram = null;
        this.geometryProgram = null;
        this.currProgram = null;
        this.initialized = false;
    }

    public GLCgShader(PApplet pApplet, String string, String string2) {
        this(pApplet);
        this.loadVertexShader(string);
        this.loadFragmentShader(string2);
        this.setup();
        this.currProgram = this.vertexProgram;
    }

    public GLCgShader(PApplet pApplet, String string, String string2, String string3) {
        this(pApplet);
        this.loadVertexShader(string);
        this.loadGeometryShader(string2);
        this.loadFragmentShader(string3);
        this.setup();
        this.currProgram = this.vertexProgram;
    }

    public void delete() {
        this.release();
    }

    public void loadVertexShader(String string) {
        String[] stringArray = this.parent.loadStrings(string);
        this.replaceIncludes(stringArray);
        String string2 = PApplet.join((String[])stringArray, (String)"\n");
        this.createVertexProgram(string2, string);
    }

    public void loadVertexShader(URL uRL) {
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            this.createVertexProgram(string, uRL.getFile());
        }
        catch (IOException iOException) {
            System.err.println("Cannot load file " + uRL.getFile());
        }
    }

    public void loadGeometryShader(String string) {
        String[] stringArray = this.parent.loadStrings(string);
        this.replaceIncludes(stringArray);
        String string2 = PApplet.join((String[])stringArray, (String)"\n");
        this.createGeometryProgram(string2, string);
    }

    public void loadGeometryShader(URL uRL) {
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            this.createGeometryProgram(string, uRL.getFile());
        }
        catch (IOException iOException) {
            System.err.println("Cannot load file " + uRL.getFile());
        }
    }

    public void loadFragmentShader(String string) {
        String[] stringArray = this.parent.loadStrings(string);
        this.replaceIncludes(stringArray);
        String string2 = PApplet.join((String[])stringArray, (String)"\n");
        this.createFragmentProgram(string2, string);
    }

    public void loadFragmentShader(URL uRL) {
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            this.createFragmentProgram(string, uRL.getFile());
        }
        catch (IOException iOException) {
            System.err.println("Cannot load file " + uRL.getFile());
        }
    }

    public void setup() {
        if (this.vertexShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.vertexProgram);
        }
        if (this.fragmentShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.fragmentProgram);
        }
        if (this.geometryShaderEnabled) {
            CgGL.cgGLLoadProgram((CGprogram)this.geometryProgram);
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void start() {
        if (!this.initialized) {
            System.err.println("This shader is not properly initialized. Call the setup() method first");
        }
        if (this.vertexShaderEnabled) {
            CgGL.cgGLBindProgram((CGprogram)this.vertexProgram);
            CgGL.cgGLEnableProfile((int)this.vertexProfile);
        }
        if (this.fragmentShaderEnabled) {
            CgGL.cgGLBindProgram((CGprogram)this.fragmentProgram);
            CgGL.cgGLEnableProfile((int)this.fragmentProfile);
        }
        if (this.geometryShaderEnabled) {
            CgGL.cgGLBindProgram((CGprogram)this.geometryProgram);
            CgGL.cgGLEnableProfile((int)this.geometryProfile);
        }
    }

    public void stop() {
        if (this.vertexShaderEnabled) {
            CgGL.cgGLDisableProfile((int)this.vertexProfile);
        }
        if (this.fragmentShaderEnabled) {
            CgGL.cgGLDisableProfile((int)this.fragmentProfile);
        }
        if (this.geometryShaderEnabled) {
            CgGL.cgGLDisableProfile((int)this.geometryProfile);
        }
    }

    public CGparameter getVertexParameter(String string) {
        return CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)string);
    }

    public CGparameter getGeometryParameter(String string) {
        return CgGL.cgGetNamedParameter((CGprogram)this.vertexProgram, (String)string);
    }

    public CGparameter getFragmentParameter(String string) {
        return CgGL.cgGetNamedParameter((CGprogram)this.fragmentProgram, (String)string);
    }

    public void setProgram(int n) {
        switch (n) {
            case 0: {
                this.currProgram = this.vertexProgram;
                break;
            }
            case 1: {
                this.currProgram = this.fragmentProgram;
                break;
            }
            case 2: {
                this.currProgram = this.geometryProgram;
                break;
            }
            default: {
                this.currProgram = this.vertexProgram;
            }
        }
    }

    public void setTexParameter(String string, GLTexture gLTexture) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetTextureParameter((CGparameter)cGparameter, (int)gLTexture.getTextureID());
        }
    }

    public void setIntParameter(String string, int n) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter1i((CGparameter)cGparameter, (int)n);
        }
    }

    public void setFloatParameter(String string, float f) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter1f((CGparameter)cGparameter, (float)f);
        }
    }

    public void setVecParameter(String string, float f, float f2) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter2f((CGparameter)cGparameter, (float)f, (float)f2);
        }
    }

    public void setVecParameter(String string, float f, float f2, float f3) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter3f((CGparameter)cGparameter, (float)f, (float)f2, (float)f3);
        }
    }

    public void setVecParameter(String string, float f, float f2, float f3, float f4) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter4f((CGparameter)cGparameter, (float)f, (float)f2, (float)f3, (float)f4);
        }
    }

    public void setMatParameter(String string, float f, float f2, float f3, float f4) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[4];
            fArray[0] = f;
            fArray[1] = f3;
            fArray[4] = f2;
            fArray[5] = f4;
            CgGL.cgSetMatrixParameterfc((CGparameter)cGparameter, (float[])fArray, (int)0);
        }
    }

    public void setMatParameter(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[9];
            fArray[0] = f;
            fArray[1] = f4;
            fArray[2] = f7;
            fArray[4] = f2;
            fArray[5] = f5;
            fArray[6] = f8;
            fArray[8] = f3;
            fArray[9] = f6;
            fArray[10] = f9;
            CgGL.cgSetMatrixParameterfc((CGparameter)cGparameter, (float[])fArray, (int)0);
        }
    }

    public void setMatParameter(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[]{f, f5, f9, f13, f2, f6, f10, f14, f3, f7, f11, f15, f4, f8, f12, f16};
            CgGL.cgSetMatrixParameterfc((CGparameter)cGparameter, (float[])fArray, (int)0);
        }
    }

    public void setModelviewMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)4, (int)0);
        }
    }

    public void setProjectionMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)5, (int)0);
        }
    }

    public void setModelviewProjectionMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)7, (int)0);
        }
    }

    public void setTextureMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)this.currProgram, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)6, (int)0);
        }
    }

    private void createVertexProgram(String string, String string2) {
        this.vertexProfile = CgGL.cgGLGetLatestProfile((int)8);
        if (this.vertexProfile == 6145) {
            System.err.println("GLCgShader:  Vertex profile could not be created");
        } else {
            CgGL.cgGLSetOptimalOptions((int)this.vertexProfile);
        }
        this.vertexProgram = (CGprogram)GLState.createCGResource(7, this.context, string, this.vertexProfile);
        this.checkErrorInfo(string2, this.vertexProgram);
        boolean bl = this.vertexShaderEnabled = this.vertexProgram != null && this.vertexProfile != 6145;
        if (!this.vertexShaderEnabled) {
            System.err.println("GLCgShader: Failed to loaded vertex program: " + string2);
        }
    }

    private void createGeometryProgram(String string, String string2) {
        this.geometryProgram = (CGprogram)GLState.createCGResource(7, this.context, string, 7000);
        this.checkErrorInfo(string2, this.geometryProgram);
        boolean bl = this.geometryShaderEnabled = this.geometryProgram != null && this.geometryProfile != 6145;
        if (!this.geometryShaderEnabled) {
            System.err.println("GLCgShader:  Failed to loaded geometry program: " + string2);
        }
    }

    private void createFragmentProgram(String string, String string2) {
        this.fragmentProfile = CgGL.cgGLGetLatestProfile((int)9);
        if (this.fragmentProfile == 6145) {
            System.err.println("GLCgShader:  Fragment profile could not be created");
        } else {
            CgGL.cgGLSetOptimalOptions((int)this.fragmentProfile);
        }
        this.fragmentProgram = (CGprogram)GLState.createCGResource(7, this.context, string, this.fragmentProfile);
        this.checkErrorInfo(string2, this.fragmentProgram);
        boolean bl = this.fragmentShaderEnabled = this.fragmentProgram != null && this.fragmentProfile != 6145;
        if (!this.fragmentShaderEnabled) {
            System.err.println("GLCgShader:  Failed to loaded fragment program: " + string2);
        }
    }

    protected void release() {
        if (this.vertexShaderEnabled) {
            GLState.deleteCGResource(this.vertexProgram, 7);
            this.vertexProgram = null;
        }
        if (this.fragmentShaderEnabled) {
            GLState.deleteCGResource(this.fragmentProgram, 7);
            this.fragmentProgram = null;
        }
        if (this.geometryShaderEnabled) {
            GLState.deleteCGResource(this.geometryProgram, 7);
            this.geometryProgram = null;
        }
        if (this.context != null) {
            GLState.deleteCGResource(this.context, 6);
            this.context = null;
        }
    }

    private void checkErrorInfo(String string, CGprogram cGprogram) {
        if (cGprogram == null) {
            int n = CgGL.cgGetError();
            System.err.println("GLCgShader:  Cg error(s) in " + string);
            System.err.println("GLCgShader:  " + CgGL.cgGetErrorString((int)n));
            System.err.println("GLCgShader:  " + CgGL.cgGetLastListing((CGcontext)this.context));
        }
    }

    protected void checkProfiles() {
        if (CgGL.cgGLIsProfileSupported((int)6150)) {
            this.vertexProfile = 6150;
            System.out.println("CG_PROFILE_ARBVP1 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)7001)) {
            this.vertexProfile = 7001;
            System.out.println("CG_PROFILE_VP40 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6148)) {
            this.vertexProfile = 6148;
            System.out.println("CG_PROFILE_VP30 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6146)) {
            this.vertexProfile = 6146;
            System.out.println("CG_PROFILE_VP20 supported");
        }
        if (CgGL.cgGLIsProfileSupported((int)7000)) {
            this.fragmentProfile = 7000;
            System.out.println("CG_PROFILE_ARBFP1 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6151)) {
            this.fragmentProfile = 6151;
            System.out.println("CG_PROFILE_FP40 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6149)) {
            this.fragmentProfile = 6149;
            System.out.println("CG_PROFILE_FP30 supported");
        } else if (CgGL.cgGLIsProfileSupported((int)6147)) {
            this.fragmentProfile = 6147;
            System.out.println("CG_PROFILE_FP20 supported");
        }
    }

    protected void replaceIncludes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            int n = string2.indexOf("#include");
            if (-1 >= n) continue;
            String string3 = string2.substring(n + 8, string2.length());
            string3 = string3.replace('\"', ' ');
            string3 = string3.trim();
            String[] stringArray2 = this.parent.loadStrings(string3);
            stringArray[i] = string = PApplet.join((String[])stringArray2, (String)"\n");
        }
    }
}

