/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLGraphics;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTextureFilter;
import codeanticode.glgraphics.GLTextureParameters;
import com.sun.opengl.util.BufferUtil;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import processing.opengl.PGraphicsOpenGL;

public class GLTexture
extends PImage
implements PConstants,
GLConstants {
    protected GL gl;
    protected PGraphicsOpenGL pgl;
    protected int tex = 0;
    protected int texTarget;
    protected int texInternalFormat;
    protected int texUnit;
    protected int texUniform;
    protected int minFilter;
    protected int magFilter;
    protected int wrapModeS;
    protected int wrapModeT;
    protected boolean usingMipmaps;
    protected float maxTexCoordS;
    protected float maxTexCoordT;
    protected boolean flippedX;
    protected boolean flippedY;
    protected int pbo = 0;
    protected int pboTarget;
    protected int pboUsage;
    protected GLState glstate;
    protected String name = "";
    protected Method disposePixelsMethod = null;
    protected Object diposePixelsHandler = null;
    protected LinkedList<PixelData> pixelBuffer = null;
    protected int maxBuffSize = 3;
    protected boolean disposeFramesWhenPixelBufferFull = false;

    public GLTexture() {
    }

    public GLTexture(PApplet pApplet) {
        super(1, 1, 2);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.setTextureParams(new GLTextureParameters());
    }

    public GLTexture(PApplet pApplet, int n, int n2) {
        super(n, n2, 2);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.setTextureParams(new GLTextureParameters());
        this.initTexture(n, n2);
    }

    public GLTexture(PApplet pApplet, int n, int n2, GLTextureParameters gLTextureParameters) {
        super(n, n2, gLTextureParameters.format);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.setTextureParams(gLTextureParameters);
        this.initTexture(n, n2);
    }

    public GLTexture(PApplet pApplet, int n, int n2, int n3) {
        super(n, n2, n3);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.setTextureParams(new GLTextureParameters(n3));
        this.initTexture(n, n2);
    }

    public GLTexture(PApplet pApplet, int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.setTextureParams(new GLTextureParameters(n3, n4));
        this.initTexture(n, n2);
    }

    public GLTexture(PApplet pApplet, String string) {
        super(1, 1, 2);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.loadTexture(string);
    }

    public GLTexture(PApplet pApplet, int n, int n2, GLTextureParameters gLTextureParameters, int n3) {
        super(n, n2, gLTextureParameters.format);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.setTextureParams(gLTextureParameters);
        this.initTexture(n, n2, n3);
    }

    public GLTexture(PApplet pApplet, String string, GLTextureParameters gLTextureParameters) {
        super(1, 1, gLTextureParameters.format);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.loadTexture(string, gLTextureParameters);
    }

    public GLTexture(PApplet pApplet, String string, int n) {
        super(1, 1, n);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.loadTexture(string, n);
    }

    public GLTexture(PApplet pApplet, String string, int n, int n2) {
        super(1, 1, n);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.loadTexture(string, n, n2);
    }

    public GLTexture(PApplet pApplet, int n) {
        super(1, 1, 2);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.calculateWidthHeight(n);
        this.init(this.width, this.height);
    }

    public GLTexture(PApplet pApplet, int n, GLTextureParameters gLTextureParameters) {
        super(1, 1, gLTextureParameters.format);
        this.parent = pApplet;
        this.pgl = (PGraphicsOpenGL)pApplet.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.calculateWidthHeight(n);
        this.init(this.width, this.height, gLTextureParameters);
    }

    public void delete() {
        if (this.tex != 0) {
            this.releaseTexture();
        }
        if (this.pixelBuffer != null && 0 < this.pixelBuffer.size() && this.disposePixelsMethod != null) {
            while (0 < this.pixelBuffer.size()) {
                PixelData pixelData = this.pixelBuffer.remove(0);
                pixelData.dispose();
            }
        }
    }

    public void init(int n, int n2) {
        this.init(n, n2, new GLTextureParameters());
    }

    public void init(int n, int n2, GLTextureParameters gLTextureParameters) {
        super.init(n, n2, gLTextureParameters.format);
        this.setTextureParams(gLTextureParameters);
        this.initTexture(n, n2);
    }

    public boolean available() {
        return 0 < this.tex;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getTextureID() {
        return this.tex;
    }

    public int getTextureUnit() {
        return this.texUnit;
    }

    public int getTextureTarget() {
        return this.texTarget;
    }

    public int getTextureInternalFormat() {
        return this.texInternalFormat;
    }

    public int getTextureMinFilter() {
        return this.minFilter;
    }

    public int getTextureMagFilter() {
        return this.magFilter;
    }

    public boolean usingMipmaps() {
        return this.usingMipmaps;
    }

    public float getMaxTextureCoordS() {
        return this.maxTexCoordS;
    }

    public float getMaxTextureCoordT() {
        return this.maxTexCoordT;
    }

    public boolean isFlippedX() {
        return this.flippedX;
    }

    public void setFlippedX(boolean bl) {
        this.flippedX = bl;
    }

    public boolean isFlippedY() {
        return this.flippedY;
    }

    public void setFlippedY(boolean bl) {
        this.flippedY = bl;
    }

    public void putImage(PImage pImage) {
        this.putImage(pImage, new GLTextureParameters());
    }

    public void putImage(PImage pImage, int n) {
        this.putImage(pImage, new GLTextureParameters(n));
    }

    public void putImage(PImage pImage, int n, int n2) {
        this.putImage(pImage, new GLTextureParameters(n, n2));
    }

    public void putImage(PImage pImage, GLTextureParameters gLTextureParameters) {
        pImage.loadPixels();
        if (pImage.width != this.width || pImage.height != this.height) {
            this.init(pImage.width, pImage.height, gLTextureParameters);
        }
        PApplet.arrayCopy((Object)pImage.pixels, (Object)this.pixels);
        this.loadTexture();
        this.updatePixels();
    }

    public void putPixelsIntoTexture(PImage pImage) {
        if (pImage.width <= 1 || pImage.height <= 1) {
            return;
        }
        if (pImage.width != this.width || pImage.height != this.height) {
            this.init(pImage.width, pImage.height, new GLTextureParameters());
        }
        if (pImage.pixels == null || pImage.pixels.length < pImage.width * pImage.height) {
            return;
        }
        if (this.texInternalFormat == 6407) {
            this.putBuffer(pImage.pixels, 1);
        }
        if (this.texInternalFormat == 6408) {
            this.putBuffer(pImage.pixels, 2);
        }
        if (this.texInternalFormat == 6406) {
            this.putBuffer(pImage.pixels, 4);
        }
    }

    public void putPixelsIntoTexture(PImage pImage, int n, int n2, int n3, int n4) {
        if (pImage.width <= 1 || pImage.height <= 1) {
            return;
        }
        n = PApplet.constrain((int)n, (int)0, (int)pImage.width);
        n2 = PApplet.constrain((int)n2, (int)0, (int)pImage.height);
        n3 = PApplet.constrain((int)n3, (int)0, (int)(pImage.width - n));
        n4 = PApplet.constrain((int)n4, (int)0, (int)(pImage.height - n2));
        if (n3 != this.width || n4 != this.height) {
            this.init(n3, n4, new GLTextureParameters());
        }
        if (pImage.pixels == null || pImage.pixels.length < pImage.width * pImage.height) {
            return;
        }
        int[] nArray = new int[n3 * n4];
        for (int i = 0; i < n4; ++i) {
            int n5 = n2 * pImage.width + n + (pImage.width - n3) * i;
            PApplet.arrayCopy((Object)pImage.pixels, (int)(n5 + n3 * i), (Object)nArray, (int)(n3 * i), (int)n3);
        }
        if (this.texInternalFormat == 6407) {
            this.putBuffer(nArray, 1);
        }
        if (this.texInternalFormat == 6408) {
            this.putBuffer(nArray, 2);
        }
        if (this.texInternalFormat == 6406) {
            this.putBuffer(nArray, 4);
        }
    }

    public void getImage(PImage pImage) {
        int n = this.width;
        int n2 = this.height;
        if (pImage.width != n || pImage.height != n2) {
            pImage.init(n, n2, 2);
        }
        int n3 = n * n2;
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)n3);
        this.gl.glBindTexture(this.texTarget, this.tex);
        this.gl.glGetTexImage(this.texTarget, 0, 6408, 5121, (Buffer)intBuffer);
        this.gl.glBindTexture(this.texTarget, 0);
        intBuffer.get(pImage.pixels);
        int[] nArray = this.convertToARGB(pImage.pixels);
        PApplet.arrayCopy((Object)nArray, (Object)pImage.pixels);
        if (this.flippedX) {
            this.flipArrayOnX(pImage.pixels, 1);
        }
        if (this.flippedY) {
            this.flipArrayOnY(pImage.pixels, 1);
        }
        pImage.updatePixels();
    }

    public void loadTexture(String string) {
        PImage pImage = this.parent.loadImage(string);
        this.putImage(pImage);
    }

    public void loadTexture(String string, GLTextureParameters gLTextureParameters) {
        PImage pImage = this.parent.loadImage(string);
        this.putImage(pImage, gLTextureParameters);
    }

    public void loadTexture(String string, int n) {
        PImage pImage = this.parent.loadImage(string);
        this.putImage(pImage, n);
    }

    public void loadTexture(String string, int n, int n2) {
        PImage pImage = this.parent.loadImage(string);
        this.putImage(pImage, n, n2);
    }

    public void loadTexture() {
        if (this.texInternalFormat == 6407) {
            this.putBuffer(this.pixels, 1);
        }
        if (this.texInternalFormat == 6408) {
            this.putBuffer(this.pixels, 2);
        }
        if (this.texInternalFormat == 6406) {
            this.putBuffer(this.pixels, 4);
        }
    }

    public void copy(GLTexture gLTexture) {
        this.glstate.copyTex(gLTexture, this);
    }

    public void loadTextureFast() {
        if (this.pbo == 0) {
            System.err.println("Fast texture load is not enabled!");
            return;
        }
        this.gl.glBindTexture(this.texTarget, this.tex);
        this.gl.glBindBuffer(this.pboTarget, this.pbo);
        IntBuffer intBuffer = this.gl.glMapBuffer(this.pboTarget, 35001).asIntBuffer();
        System.out.println(intBuffer);
        intBuffer.put(this.pixels);
        this.gl.glUnmapBufferARB(this.pboTarget);
        this.gl.glBindBuffer(this.pboTarget, 0);
    }

    public void enableFastTextureLoad() {
        if (this.pbo != 0) {
            this.releasePBO();
        }
        this.pbo = GLState.createGLResource(1);
        this.pboTarget = 35052;
        this.pboUsage = 35048;
        this.pboUsage = 35040;
        this.gl.glBindBufferARB(this.pboTarget, this.pbo);
        this.gl.glBufferDataARB(this.pboTarget, 4 * this.width * this.height, null, this.pboUsage);
        this.gl.glBindBufferARB(this.pboTarget, 0);
    }

    public void updateTexture() {
        int n = this.width * this.height;
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)n);
        this.gl.glBindTexture(this.texTarget, this.tex);
        this.gl.glGetTexImage(this.texTarget, 0, 6408, 5121, (Buffer)intBuffer);
        this.gl.glBindTexture(this.texTarget, 0);
        intBuffer.get(this.pixels);
        int[] nArray = this.convertToARGB(this.pixels);
        PApplet.arrayCopy((Object)nArray, (Object)this.pixels);
        if (this.flippedX) {
            this.flipArrayOnX(this.pixels, 1);
        }
        if (this.flippedY) {
            this.flipArrayOnY(this.pixels, 1);
        }
    }

    public void filter(GLTextureFilter gLTextureFilter, GLTexture gLTexture) {
        gLTextureFilter.apply(new GLTexture[]{this}, new GLTexture[]{gLTexture});
    }

    public void filter(GLTextureFilter gLTextureFilter, GLTexture gLTexture, float[] ... fArray) {
        gLTextureFilter.setParameterValues(fArray);
        gLTextureFilter.apply(new GLTexture[]{this}, new GLTexture[]{gLTexture});
    }

    public void filter(GLTextureFilter gLTextureFilter, GLTexture gLTexture, float f) {
        gLTextureFilter.apply(new GLTexture[]{this}, new GLTexture[]{gLTexture}, null, 1.0f, 1.0f, 1.0f, f);
    }

    public void filter(GLTextureFilter gLTextureFilter, GLTexture gLTexture, float f, float[] ... fArray) {
        gLTextureFilter.setParameterValues(fArray);
        gLTextureFilter.apply(new GLTexture[]{this}, new GLTexture[]{gLTexture}, null, 1.0f, 1.0f, 1.0f, f);
    }

    public void filter(GLTextureFilter gLTextureFilter, GLTexture[] gLTextureArray, float f) {
        gLTextureFilter.apply(new GLTexture[]{this}, gLTextureArray, null, 1.0f, 1.0f, 1.0f, f);
    }

    public void filter(GLTextureFilter gLTextureFilter, GLTexture[] gLTextureArray, float f, float[] ... fArray) {
        gLTextureFilter.setParameterValues(fArray);
        gLTextureFilter.apply(new GLTexture[]{this}, gLTextureArray, null, 1.0f, 1.0f, 1.0f, f);
    }

    public void render() {
        this.render(0.0f, 0.0f, this.width, this.height);
    }

    public void render(float f, float f2) {
        this.render(f, f2, this.width, this.height);
    }

    public void render(float f, float f2, float f3, float f4) {
        this.render(this.pgl, f, f2, f3, f4);
    }

    public void render(PGraphicsOpenGL pGraphicsOpenGL, float f, float f2, float f3, float f4) {
        this.render(pGraphicsOpenGL, f, f2, f3, f4, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void render(PGraphicsOpenGL pGraphicsOpenGL, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        if (pGraphicsOpenGL.textureMode == 2) {
            f10 = this.width;
            f9 = this.height;
        } else {
            f10 = 1.0f;
            f9 = 1.0f;
        }
        pGraphicsOpenGL.beginShape(16);
        pGraphicsOpenGL.texture((PImage)this);
        pGraphicsOpenGL.vertex(f, f2, f10 * f5, f9 * f6);
        pGraphicsOpenGL.vertex(f + f3, f2, f10 * f7, f9 * f6);
        pGraphicsOpenGL.vertex(f + f3, f2 + f4, f10 * f7, f9 * f8);
        pGraphicsOpenGL.vertex(f, f2 + f4, f10 * f5, f9 * f8);
        pGraphicsOpenGL.endShape();
    }

    public void putBuffer(int[] nArray) {
        this.putBuffer(nArray, 2, 1);
    }

    public void putBuffer(int[] nArray, int n) {
        this.putBuffer(nArray, n, 1);
    }

    public void putByteBuffer(int[] nArray, int n) {
        this.putBuffer(nArray, n, 1);
    }

    public void putIntBuffer(int[] nArray, int n) {
        this.putBuffer(nArray, n, 0);
    }

    public void putBuffer(int[] nArray, int n, int n2) {
        int n3;
        if (this.tex == 0) {
            this.initTexture(this.width, this.height);
        }
        int[] nArray2 = nArray;
        if (n == 4) {
            n3 = 6406;
            if (n2 == 1) {
                byte[] byArray = this.convertToAlpha(nArray);
                this.gl.glBindTexture(this.texTarget, this.tex);
                this.gl.glTexSubImage2D(this.texTarget, 0, 0, 0, this.width, this.height, n3, 5121, (Buffer)ByteBuffer.wrap(byArray));
                this.gl.glBindTexture(this.texTarget, 0);
                return;
            }
        } else if (n == 1) {
            n3 = 6408;
            if (n2 == 1) {
                nArray2 = this.convertToRGBA(nArray, 1);
            }
        } else {
            n3 = 6408;
            if (n2 == 1) {
                nArray2 = this.convertToRGBA(nArray, 2);
            }
        }
        int n4 = n2 == 0 ? 5124 : 5121;
        this.putBuffer(n3, n4, IntBuffer.wrap(nArray2));
    }

    protected void putBuffer(int n, int n2, IntBuffer intBuffer) {
        this.gl.glBindTexture(this.texTarget, this.tex);
        if (this.texTarget == 3552) {
            this.gl.glTexSubImage1D(this.texTarget, 0, 0, this.width, n, n2, (Buffer)intBuffer);
        } else if (this.usingMipmaps) {
            GLState.glu.gluBuild2DMipmaps(this.texTarget, this.texInternalFormat, this.width, this.height, n, n2, (Buffer)intBuffer);
        } else {
            this.gl.glTexSubImage2D(this.texTarget, 0, 0, 0, this.width, this.height, n, n2, (Buffer)intBuffer);
        }
        this.gl.glBindTexture(this.texTarget, 0);
    }

    public void putBuffer(float[] fArray) {
        this.putBuffer(fArray, 4);
    }

    public void putBuffer(float[] fArray, int n) {
        if (this.tex == 0) {
            this.initTexture(this.width, this.height);
        }
        int n2 = n == 1 ? 6409 : (n == 3 ? 6407 : 6408);
        this.gl.glBindTexture(this.texTarget, this.tex);
        if (this.texTarget == 3552) {
            this.gl.glTexSubImage1D(this.texTarget, 0, 0, this.width, n2, 5126, (Buffer)FloatBuffer.wrap(fArray));
        } else {
            this.gl.glTexSubImage2D(this.texTarget, 0, 0, 0, this.width, this.height, n2, 5126, (Buffer)FloatBuffer.wrap(fArray));
        }
        this.gl.glBindTexture(this.texTarget, 0);
    }

    public void getBuffer(int[] nArray) {
        this.getBuffer(nArray, 2, 1);
    }

    public void getBuffer(int[] nArray, int n) {
        this.getBuffer(nArray, n, 1);
    }

    public void getByteBuffer(int[] nArray, int n) {
        this.getBuffer(nArray, n, 1);
    }

    public void getIntBuffer(int[] nArray, int n) {
        this.getBuffer(nArray, n, 0);
    }

    public void getBuffer(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n == 4) {
            n5 = 1;
            n4 = 6409;
        } else if (n == 1) {
            n5 = 3;
            n4 = 6407;
        } else {
            n5 = 4;
            n4 = 6408;
        }
        if (n2 == 0) {
            n3 = 5124;
        } else {
            n5 = 1;
            n3 = 5121;
        }
        int n6 = n5 * this.width * this.height;
        if (nArray.length != n6) {
            System.err.println("Wrong size of buffer!");
            return;
        }
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)n6);
        this.gl.glBindTexture(this.texTarget, this.tex);
        this.gl.glGetTexImage(this.texTarget, 0, n4, n3, (Buffer)intBuffer);
        this.gl.glBindTexture(this.texTarget, 0);
        intBuffer.get(nArray);
        if (this.flippedX) {
            this.flipArrayOnX(nArray, n5);
        }
        if (this.flippedY) {
            this.flipArrayOnY(nArray, n5);
        }
    }

    public void getBuffer(float[] fArray, int n) {
        int n2;
        int n3;
        if (n == 1) {
            n3 = 1;
            n2 = 6409;
        } else if (n == 3) {
            n3 = 3;
            n2 = 6407;
        } else {
            n3 = 4;
            n2 = 6408;
        }
        int n4 = n3 * this.width * this.height;
        if (fArray.length != n4) {
            System.err.println("Wrong size of buffer!");
            return;
        }
        FloatBuffer floatBuffer = BufferUtil.newFloatBuffer((int)n4);
        this.gl.glBindTexture(this.texTarget, this.tex);
        this.gl.glGetTexImage(this.texTarget, 0, n2, 5126, (Buffer)floatBuffer);
        this.gl.glBindTexture(this.texTarget, 0);
        floatBuffer.get(fArray);
        if (this.flippedX) {
            this.flipArrayOnX(fArray, n3);
        }
        if (this.flippedY) {
            this.flipArrayOnY(fArray, n3);
        }
    }

    public void setRandom(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float[] fArray = new float[4 * this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                fArray[j * 4 + i * this.width * 4] = this.parent.random(f, f2);
                fArray[j * 4 + i * this.width * 4 + 1] = this.parent.random(f3, f4);
                fArray[j * 4 + i * this.width * 4 + 2] = this.parent.random(f5, f6);
                fArray[j * 4 + i * this.width * 4 + 3] = this.parent.random(f7, f8);
            }
        }
        this.putBuffer(fArray);
    }

    public void setRandomDir2D(float f, float f2, float f3, float f4) {
        float[] fArray = new float[4 * this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                float f5 = this.parent.random(f, f2);
                float f6 = this.parent.random(f3, f4);
                fArray[j * 4 + i * this.width * 4] = f5 * PApplet.cos((float)f6);
                fArray[j * 4 + i * this.width * 4 + 1] = f5 * PApplet.sin((float)f6);
                fArray[j * 4 + i * this.width * 4 + 2] = 0.0f;
                fArray[j * 4 + i * this.width * 4 + 3] = 0.0f;
            }
        }
        this.putBuffer(fArray);
    }

    public void setRandomDir3D(float f, float f2, float f3, float f4, float f5, float f6) {
        float[] fArray = new float[4 * this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                float f7 = this.parent.random(f, f2);
                float f8 = this.parent.random(f3, f4);
                float f9 = this.parent.random(f5, f6);
                fArray[j * 4 + i * this.width * 4] = f7 * PApplet.cos((float)f8) * PApplet.sin((float)f9);
                fArray[j * 4 + i * this.width * 4 + 1] = f7 * PApplet.sin((float)f8) * PApplet.sin((float)f9);
                fArray[j * 4 + i * this.width * 4 + 2] = f7 * PApplet.cos((float)f9);
                fArray[j * 4 + i * this.width * 4 + 3] = 0.0f;
            }
        }
        this.putBuffer(fArray);
    }

    public void setValue(float f, float f2, float f3, float f4) {
        float[] fArray = new float[4 * this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                fArray[j * 4 + i * this.width * 4] = f;
                fArray[j * 4 + i * this.width * 4 + 1] = f2;
                fArray[j * 4 + i * this.width * 4 + 2] = f3;
                fArray[j * 4 + i * this.width * 4 + 3] = f4;
            }
        }
        this.putBuffer(fArray);
    }

    public void setZero() {
        this.setValue(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void clear(int n) {
        int n2 = this.parent.color(n);
        this.glstate.clearTex(this.tex, this.texTarget, n2);
    }

    public void clear(float f) {
        int n = this.parent.color(f);
        this.glstate.clearTex(this.tex, this.texTarget, n);
    }

    public void clear(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.glstate.clearTex(this.tex, this.texTarget, n3);
    }

    public void clear(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.glstate.clearTex(this.tex, this.texTarget, n2);
    }

    public void clear(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.glstate.clearTex(this.tex, this.texTarget, n);
    }

    public void clear(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.glstate.clearTex(this.tex, this.texTarget, n4);
    }

    public void clear(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.glstate.clearTex(this.tex, this.texTarget, n);
    }

    public void clear(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.glstate.clearTex(this.tex, this.texTarget, n5);
    }

    public void clear(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.glstate.clearTex(this.tex, this.texTarget, n);
    }

    public void paint(int n) {
        int n2 = this.parent.color(n);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n2);
    }

    public void paint(float f) {
        int n = this.parent.color(f);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n);
    }

    public void paint(int n, int n2) {
        int n3 = this.parent.color(n, n2);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n3);
    }

    public void paint(int n, float f) {
        int n2 = this.parent.color((float)n, f);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n2);
    }

    public void paint(float f, float f2) {
        int n = this.parent.color(f, f2);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n);
    }

    public void paint(int n, int n2, int n3) {
        int n4 = this.parent.color(n, n2, n3);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n4);
    }

    public void paint(float f, float f2, float f3) {
        int n = this.parent.color(f, f2, f3);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n);
    }

    public void paint(int n, int n2, int n3, int n4) {
        int n5 = this.parent.color(n, n2, n3, n4);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n5);
    }

    public void paint(float f, float f2, float f3, float f4) {
        int n = this.parent.color(f, f2, f3, f4);
        this.glstate.paintTex(this.tex, this.texTarget, this.width, this.height, n);
    }

    protected void bind(int n) {
        this.texUnit = n;
        this.gl.glActiveTexture(33984 + this.texUnit);
        this.gl.glBindTexture(this.texTarget, this.tex);
        if (-1 < this.texUniform) {
            this.gl.glUniform1iARB(this.texUniform, this.texUnit);
        }
    }

    protected void unbind() {
        if (-1 < this.texUnit) {
            this.gl.glActiveTexture(33984 + this.texUnit);
            this.gl.glBindTexture(this.texTarget, 0);
            this.texUnit = -1;
            if (-1 < this.texUniform) {
                this.texUniform = -1;
            }
        }
    }

    protected void setTexUniform(int n) {
        this.texUniform = n;
    }

    public void setPixelSource(Object object) {
        this.diposePixelsHandler = object;
        try {
            this.disposePixelsMethod = object.getClass().getMethod("disposeBuffer", Object.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean putPixelsIntoTexture() {
        if (this.pixelBuffer != null && 0 < this.pixelBuffer.size() && this.disposePixelsMethod != null) {
            PixelData pixelData = this.pixelBuffer.remove(0);
            if (pixelData.w != this.width || pixelData.h != this.height) {
                this.init(pixelData.w, pixelData.h, new GLTextureParameters());
            }
            this.putBuffer(6408, 5121, pixelData.rgbBuf);
            pixelData.dispose();
            return true;
        }
        return false;
    }

    public void setPixelBufferSize(int n) {
        this.maxBuffSize = n;
    }

    public int getPixelBufferUse() {
        return this.pixelBuffer.size();
    }

    public void delPixelsWhenBufferFull(boolean bl) {
        this.disposeFramesWhenPixelBufferFull = bl;
    }

    public void addPixelsToBuffer(Object object, IntBuffer intBuffer, int n, int n2) {
        if (this.pixelBuffer == null) {
            this.pixelBuffer = new LinkedList();
        }
        if (this.pixelBuffer.size() + 1 <= this.maxBuffSize) {
            this.pixelBuffer.add(new PixelData(object, intBuffer, n, n2));
        } else if (this.disposeFramesWhenPixelBufferFull) {
            try {
                this.disposePixelsMethod.invoke(this.diposePixelsHandler, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void flipArrayOnX(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n * (this.width - 1);
        for (int i = 0; i < this.width / 2; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int n4 = n2 + n * j * this.width;
                int n5 = n3 + n * j * this.width;
                for (int k = 0; k < n; ++k) {
                    int n6 = nArray[n4];
                    nArray[n4] = nArray[n5];
                    nArray[n5] = n6;
                    ++n4;
                    ++n5;
                }
            }
            n2 += n;
            n3 -= n;
        }
    }

    protected void flipArrayOnY(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n * (this.height - 1) * this.width;
        for (int i = 0; i < this.height / 2; ++i) {
            for (int j = 0; j < n * this.width; ++j) {
                int n4 = nArray[n2];
                nArray[n2] = nArray[n3];
                nArray[n3] = n4;
                ++n2;
                ++n3;
            }
            n3 -= n * this.width * 2;
        }
    }

    protected void flipArrayOnX(float[] fArray, int n) {
        int n2 = 0;
        int n3 = n * (this.width - 1);
        for (int i = 0; i < this.width / 2; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int n4 = n2 + n * j * this.width;
                int n5 = n3 + n * j * this.width;
                for (int k = 0; k < n; ++k) {
                    float f = fArray[n4];
                    fArray[n4] = fArray[n5];
                    fArray[n5] = f;
                    ++n4;
                    ++n5;
                }
            }
            n2 += n;
            n3 -= n;
        }
    }

    protected void flipArrayOnY(float[] fArray, int n) {
        int n2 = 0;
        int n3 = n * (this.height - 1) * this.width;
        for (int i = 0; i < this.height / 2; ++i) {
            for (int j = 0; j < n * this.width; ++j) {
                float f = fArray[n2];
                fArray[n2] = fArray[n3];
                fArray[n3] = f;
                ++n2;
                ++n3;
            }
            n3 -= n * this.width * 2;
        }
    }

    protected int[] convertToRGBA(int[] nArray, int n) {
        int[] nArray2;
        block23: {
            int n2;
            int n3;
            block22: {
                n3 = this.width;
                int n4 = 0;
                n2 = 0;
                nArray2 = new int[this.width * this.height];
                if (!GLGraphics.BIG_ENDIAN) break block22;
                switch (n) {
                    case 4: {
                        for (int i = 0; i < this.height; ++i) {
                            for (int j = 0; j < this.width; ++j) {
                                nArray2[n4++] = 0xFFFFFF00 | nArray[n2++];
                            }
                            n4 += n3 - this.width;
                        }
                        break block23;
                    }
                    case 1: {
                        for (int i = 0; i < this.height; ++i) {
                            for (int j = 0; j < this.width; ++j) {
                                int n5 = nArray[n2++];
                                nArray2[n4++] = n5 << 8 | 0xFF;
                            }
                            n4 += n3 - this.width;
                        }
                        break block23;
                    }
                    case 2: {
                        for (int i = 0; i < this.height; ++i) {
                            for (int j = 0; j < this.width; ++j) {
                                int n6 = nArray[n2++];
                                nArray2[n4++] = n6 << 8 | n6 >> 24 & 0xFF;
                            }
                            n4 += n3 - this.width;
                        }
                        break;
                    }
                }
                break block23;
            }
            switch (n) {
                case 4: {
                    for (int i = 0; i < this.height; ++i) {
                        for (int j = 0; j < this.width; ++j) {
                            nArray2[n4++] = nArray[n2++] << 24 | 0xFFFFFF;
                        }
                        n4 += n3 - this.width;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.height; ++i) {
                        for (int j = 0; j < this.width; ++j) {
                            int n7 = nArray[n2++];
                            nArray2[n4++] = 0xFF000000 | (n7 & 0xFF) << 16 | (n7 & 0xFF0000) >> 16 | n7 & 0xFF00;
                        }
                        n4 += n3 - this.width;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.height; ++i) {
                        for (int j = 0; j < this.width; ++j) {
                            int n8 = nArray[n2++];
                            nArray2[n4++] = (n8 & 0xFF) << 16 | (n8 & 0xFF0000) >> 16 | n8 & 0xFF00FF00;
                        }
                        n4 += n3 - this.width;
                    }
                    break;
                }
            }
        }
        return nArray2;
    }

    protected int[] convertToARGB(int[] nArray) {
        int n = this.width;
        int n2 = 0;
        int n3 = 0;
        int[] nArray2 = new int[this.width * this.height];
        if (GLGraphics.BIG_ENDIAN) {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n4 = nArray[n3++];
                    nArray2[n2++] = n4 >> 8 | n4 << 24 & 0xFF;
                }
                n2 += n - this.width;
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n5 = nArray[n3++];
                    nArray2[n2++] = (n5 & 0xFF) << 16 | (n5 & 0xFF0000) >> 16 | n5 & 0xFF00FF00;
                }
                n2 += n - this.width;
            }
        }
        return nArray2;
    }

    protected byte[] convertToAlpha(int[] nArray) {
        byte[] byArray = new byte[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    protected void initTexture(int n, int n2) {
        if (this.tex != 0) {
            this.releaseTexture();
        }
        this.tex = GLState.createGLResource(0);
        this.gl.glBindTexture(this.texTarget, this.tex);
        this.gl.glTexParameteri(this.texTarget, 10241, this.minFilter);
        this.gl.glTexParameteri(this.texTarget, 10240, this.magFilter);
        this.gl.glTexParameteri(this.texTarget, 10242, this.wrapModeS);
        this.gl.glTexParameteri(this.texTarget, 10243, this.wrapModeT);
        if (this.texTarget == 3552) {
            this.gl.glTexImage1D(this.texTarget, 0, this.texInternalFormat, n, 0, 6408, 5121, null);
        } else {
            this.gl.glTexImage2D(this.texTarget, 0, this.texInternalFormat, n, n2, 0, 6408, 5121, null);
        }
        this.gl.glBindTexture(this.texTarget, 0);
        if (this.texTarget == 34037) {
            this.maxTexCoordS = n;
            this.maxTexCoordT = n2;
        } else {
            this.maxTexCoordS = 1.0f;
            this.maxTexCoordT = 1.0f;
        }
    }

    protected void initTexture(int n, int n2, int n3) {
        if (this.tex != 0) {
            this.releaseTexture();
        }
        this.tex = n3;
        this.gl.glBindTexture(this.texTarget, this.tex);
        this.gl.glTexParameteri(this.texTarget, 10241, this.minFilter);
        this.gl.glTexParameteri(this.texTarget, 10240, this.magFilter);
        this.gl.glTexParameteri(this.texTarget, 10242, this.wrapModeS);
        this.gl.glTexParameteri(this.texTarget, 10243, this.wrapModeT);
        if (this.texTarget == 3552) {
            this.gl.glTexImage1D(this.texTarget, 0, this.texInternalFormat, n, 0, 6408, 5121, null);
        } else {
            this.gl.glTexImage2D(this.texTarget, 0, this.texInternalFormat, n, n2, 0, 6408, 5121, null);
        }
        this.gl.glBindTexture(this.texTarget, 0);
        if (this.texTarget == 34037) {
            this.maxTexCoordS = n;
            this.maxTexCoordT = n2;
        } else {
            this.maxTexCoordS = 1.0f;
            this.maxTexCoordT = 1.0f;
        }
    }

    protected void releaseTexture() {
        GLState.deleteGLResource(this.tex, 0);
        this.tex = 0;
    }

    protected void releasePBO() {
        GLState.deleteGLResource(this.pbo, 1);
        this.pbo = 0;
    }

    protected void setTextureParams(GLTextureParameters gLTextureParameters) {
        if (gLTextureParameters.target == 0) {
            this.texTarget = 3553;
        } else if (gLTextureParameters.target == 1) {
            this.texTarget = 34037;
        } else if (gLTextureParameters.target == 2) {
            this.texTarget = 3552;
        }
        if (gLTextureParameters.format == 1) {
            this.texInternalFormat = 6407;
        }
        if (gLTextureParameters.format == 2) {
            this.texInternalFormat = 6408;
        }
        if (gLTextureParameters.format == 4) {
            this.texInternalFormat = 6406;
        } else if (gLTextureParameters.format == 6) {
            this.texInternalFormat = 34842;
        } else if (gLTextureParameters.format == 7) {
            this.texInternalFormat = 34836;
        }
        if (gLTextureParameters.minFilter == 0) {
            this.minFilter = 9728;
        } else if (gLTextureParameters.minFilter == 1) {
            this.minFilter = 9729;
        } else if (gLTextureParameters.minFilter == 2) {
            this.minFilter = 9984;
        } else if (gLTextureParameters.minFilter == 3) {
            this.minFilter = 9985;
        } else if (gLTextureParameters.minFilter == 4) {
            this.minFilter = 9986;
        } else if (gLTextureParameters.minFilter == 5) {
            this.minFilter = 9987;
        }
        if (gLTextureParameters.magFilter == 0) {
            this.magFilter = 9728;
        } else if (gLTextureParameters.magFilter == 1) {
            this.magFilter = 9729;
        }
        if (gLTextureParameters.wrappingU == 0) {
            this.wrapModeS = 10496;
        } else if (gLTextureParameters.wrappingU == 1) {
            this.wrapModeS = 10497;
        }
        if (gLTextureParameters.wrappingV == 0) {
            this.wrapModeT = 10496;
        } else if (gLTextureParameters.wrappingV == 1) {
            this.wrapModeT = 10497;
        }
        this.usingMipmaps = this.minFilter == 9984 || this.minFilter == 9985 || this.minFilter == 9986 || this.minFilter == 9987;
        this.flippedX = false;
        this.flippedY = false;
        this.texUnit = -1;
        this.texUniform = -1;
    }

    protected void calculateWidthHeight(int n) {
        float f = PApplet.sqrt((float)n);
        int n2 = 2;
        while ((float)n2 < f) {
            n2 *= 2;
        }
        int n3 = n2 * n2;
        int n4 = n2 * n2 / 2;
        int n5 = PApplet.abs((int)(n3 - n)) < PApplet.abs((int)(n4 - n)) ? n2 : n2 / 2;
        this.width = n2;
        this.height = n5;
    }

    protected class PixelData {
        int w;
        int h;
        Object natBuf;
        IntBuffer rgbBuf;

        PixelData(Object object, IntBuffer intBuffer, int n, int n2) {
            this.natBuf = object;
            this.rgbBuf = intBuffer;
            this.w = n;
            this.h = n2;
        }

        void dispose() {
            try {
                GLTexture.this.disposePixelsMethod.invoke(GLTexture.this.diposePixelsHandler, this.natBuf);
                this.natBuf = null;
                this.rgbBuf = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

