#include version.txt

uniform sampler2D velocities_u;
uniform sampler2D velocities_u_prev;
uniform float buffer_size;

void main() {	
    float step = 1.0 / buffer_size;
        

	gl_FragColor =  texture2D(velocities_u, gl_TexCoord[0].xy) - vec4(0.5) *
                   (texture2D(velocities_u_prev, gl_TexCoord[0].xy + vec2(step, 0.0)) - 
                    texture2D(velocities_u_prev, gl_TexCoord[0].xy - vec2(step, 0.0))) / vec4(step);
}
