#include Includes.txt

uniform sampler2D image;
uniform float brightness;
uniform float contrast;
uniform float negative;
uniform float fade;
uniform vec3 fade_color;

uniform vec2 gradient_scroll;
uniform vec3 gradient_col0;
uniform vec3 gradient_col1;

uniform float vignett_radius;

uniform sampler2D noise;
uniform float noise_offset;
uniform float noise_strength;

uniform sampler1D threshold;

void main() {
    
    // Brightness & Contrast
	vec4 fragment = brightnessContrast(texture2D(image, gl_TexCoord[0].xy), brightness, contrast);
	
	
    // Gradient
	float coord = sin(gl_TexCoord[0].x + (gradient_scroll.x * 8.0)) * sin(gl_TexCoord[0].y + (gradient_scroll.y * 8.0));
    fragment = overlay(fragment, vec4(mix(gradient_col0, gradient_col1, vec3(coord)), 1.0));
	
	
	// Negativ
	vec4 neg = 1.0 - fragment;
	fragment = mix(fragment, neg, negative);

	
	// Vignett
	float x = gl_TexCoord[0].x - 0.5;
	float y = gl_TexCoord[0].y - 0.5;
	float v = (sqrt(pow(x, 2.0) + pow(y, 2.0))) * vignett_radius;
	fragment = fragment - vec4(v, v, v, 0.0);
	
	
	// Noise
	float r = mod((texture2D(noise, gl_TexCoord[0].xy) + noise_offset).r * 15.0, 1.0);
	float g = mod((texture2D(noise, gl_TexCoord[0].xy) + noise_offset + 0.5).g * 15.0, 1.0);
	float b = mod((texture2D(noise, gl_TexCoord[0].xy) + noise_offset - 0.75).b * 15.0, 1.0);
    vec4 noise_value = vec4(r, g, b, 1.0);
    fragment = fragment + (vec4(1.0) - fragment) * (noise_value * noise_strength);    
	
	
	// Dot Overlay
	float xc = gl_TexCoord[0].x - 0.5;
	float yc = gl_TexCoord[0].y - 0.5;

	float col = 1.125 / (1.25 - sqrt((xc * xc) + (yc * yc))) + 0.0;

	float depth = 1.0;

	float fxc = (xc * depth) / (-col * depth);
	float fyc = (yc * depth) / (-col * depth);

	float frequency = 550.0;
	float spacing = 0.75;

	col = abs((sin((-fxc + 0.5) * frequency) / spacing) * (sin((-fyc + 0.5) * frequency) / spacing));

    fragment = fragment - texture1D(threshold, 1.0 - col) / 8.0;
	
	
    // Fade
   	gl_FragColor = mix(fragment, vec4(fade_color, 1.0), fade);	
}
