#include version.txt

uniform vec4 values;
uniform float buffer_size;
uniform float boundaries;
uniform sampler2D buffer;

void main() {	

    float step = 1.0 / buffer_size;

    bool nothing = true;
        
    if(gl_TexCoord[0].x < step) {
        gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy + vec2(step, 0.0));        
        nothing = false;
    }            
    
    if(gl_TexCoord[0].x > step * (buffer_size - 1.0)) {
        gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy - vec2(step, 0.0));                
        nothing = false;        
    }
    
    
    if(gl_TexCoord[0].y < step) {
        gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy + vec2(0.0, step));        
        nothing = false;        
    }
    
    if(gl_TexCoord[0].y > step * (buffer_size - 1.0)) {
        gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy - vec2(0.0, step));        
        nothing = false;        
    }    
    
        
    // h
    if(gl_TexCoord[0].x < step && boundaries == 0.0) {
        gl_FragColor = -texture2D(buffer, gl_TexCoord[0].xy + vec2(step, 0.0));        
        nothing = false;        
    }
                
    if(gl_TexCoord[0].x > step * (buffer_size - 1.0) && boundaries == 0.0) {
        gl_FragColor = -texture2D(buffer, gl_TexCoord[0].xy - vec2(step, 0.0));                
        nothing = false;        
    }
    
    
    // v
    if(gl_TexCoord[0].y < step && boundaries == 1.0) {        
        gl_FragColor = -texture2D(buffer, gl_TexCoord[0].xy + vec2(0.0, step));        
        nothing = false;        
    }
    
    if(gl_TexCoord[0].y > step * (buffer_size - 1.0) && boundaries == 1.0) {
        gl_FragColor = -texture2D(buffer, gl_TexCoord[0].xy - vec2(0.0, step));        
        nothing = false;        
    }    
        
    
    // corners
    // top left
    if(gl_TexCoord[0].x < step && gl_TexCoord[0].y < step) {
        gl_FragColor = 0.5 * texture2D(buffer, gl_TexCoord[0].xy + vec2(step, 0.0)) + texture2D(buffer, gl_TexCoord[0].xy + vec2(0.0, step));                
    }        
        
    // bottom left
    if(gl_TexCoord[0].x < step && gl_TexCoord[0].y > step * (buffer_size - 1.0)) {
        gl_FragColor = 0.5 * texture2D(buffer, gl_TexCoord[0].xy + vec2(step, step * buffer_size)) + texture2D(buffer, gl_TexCoord[0].xy + vec2(0.0, step * (buffer_size - 1.0)));                        
    }       
        
    // top right
    if(gl_TexCoord[0].x > step * (buffer_size - 1.0) && gl_TexCoord[0].y < step) {
        gl_FragColor = 0.5 * texture2D(buffer, gl_TexCoord[0].xy + vec2(step * (buffer_size - 1.0), 0.0)) + texture2D(buffer, gl_TexCoord[0].xy + vec2(step * buffer_size, step));
    }
    
    // bottom right
    if(gl_TexCoord[0].x > step * (buffer_size - 1.0) && gl_TexCoord[0].y > step * (buffer_size - 1.0)) {
        gl_FragColor = 0.5 * texture2D(buffer, gl_TexCoord[0].xy + vec2(step * (buffer_size - 1.0), step * buffer_size)) + 
                             texture2D(buffer, gl_TexCoord[0].xy + vec2(step * buffer_size, step * (buffer_size - 1.0)));                
    }        
    
    
    if(nothing) {
       gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy);
    }
    

/*

    if(boundaries == 0.0) {
        if(gl_TexCoord[0].x < step) {
            gl_FragColor = vec4(values[3]);        
        }
        else if(gl_TexCoord[0].x > step * (buffer_size - 1.0)) {
            gl_FragColor = vec4(values[1]);        
        }    
        else {
            gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy);
        }
    }

    if(boundaries == 1.0) {
        if(gl_TexCoord[0].y < step) {
            gl_FragColor = vec4(values[0]);
        }
        else if(gl_TexCoord[0].y > step * (buffer_size - 1.0)) {
            gl_FragColor = vec4(values[2]);
        }    
        else {
            gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy);
        }
    }

    if(boundaries == 2.0) {
        if(gl_TexCoord[0].y < step) {
            gl_FragColor = vec4(values[0]);
        }
        else if(gl_TexCoord[0].y > step * (buffer_size - 1.0)) {
            gl_FragColor = vec4(values[2]);
        }    
        else if(gl_TexCoord[0].x < step) {
            gl_FragColor = vec4(values[3]);        
        }
        else if(gl_TexCoord[0].x > step * (buffer_size - 1.0)) {
            gl_FragColor = vec4(values[1]);        
        }    
        else {
            gl_FragColor = texture2D(buffer, gl_TexCoord[0].xy);
        }
    }
*/    
    
}
