
#version 120

varying vec2 texcoord;

uniform sampler2D tex;
uniform sampler1D deform;     
uniform float halfypixel;

// deform:
//   x = xoffset
//   y = hue-factor = red-shrink
//   z = hueoffset
//   w = saturation factor

//------------------------------------------------------------------------------

vec3 rgb_to_hsl(vec3 rgb)
{ float p,q;
  p = min ( min ( rgb.r , rgb.g ) , rgb.b );
  q = max ( max ( rgb.r , rgb.g ) , rgb.b );
  vec3 mask = step( vec3(0.0) , rgb - vec3(q) );  // 1 a maximumra, 0 amugy. Remelem :)
  // (rgb.gbr - rgb.brg) = cross(rgb,vec3(1.0));
  vec3 hhh = fract ( mask * ( vec3(1.0, 0.33333333, 0.66666666) + (rgb.gbr - rgb.brg) * (0.16666666/(q-p)) ) ); 
  float h = (hhh.x + hhh.y + hhh.z) / (mask.x + mask.y + mask.z) ;
  float l2 = p+q;
  return ( vec3( h, (q-p)/(1.0-abs(l2-1.0)), 0.5*l2 ) ); 
}

/*
vec4 rgba_to_hsla(vec4 rgba) 
{ return ( vec4 ( rgb_to_hsl(rgb.xyz) , rgb.w) );
}
*/

//------------------------------------------------------------------------------

vec3 hsl_to_rgb(vec3 hsl) 
{ float h = hsl.x;
  vec3 rgb = clamp 
    ( vec3 
      ( - 1.0 + 6.0 * abs ( h - 0.5        )
      ,   2.0 - 6.0 * abs ( h - 0.33333333 ) 
      ,   2.0 - 6.0 * abs ( h - 0.66666666 ) 
      ) 
    , 0.0 
    , 1.0 
    );
  float s = hsl.y;
  float l = hsl.z;
  float x = s * (0.5-abs(l-0.5));
  return ( mix ( vec3(l-x), vec3(l+x) , rgb ) );
}

/*
vec4 hsla_to_rgba(vec4 hsla) 
{ return ( vec4 ( hsl_to_rgb(hsla.xyz) , hsla.w) );
}
*/

//------------------------------------------------------------------------------

float circular_diff ( float x, float y)
{
  return ( 0.5 - abs( abs(x-y) - 0.5 ) );  
}

//------------------------------------------------------------------------------

void main()
{  
  vec4 ofs = texture1D( deform, texcoord.y + halfypixel ) ;
  vec3 col = texture2D( tex, texcoord + vec2(ofs.x * 0.25,0.0) ).rgb;
  vec3 hsl = rgb_to_hsl(col);
  hsl.x = fract ( hsl.x * ofs.y + ofs.z );
  hsl.y = min ( hsl.y * ofs.w  , 1.0 );  
  gl_FragColor.rgb = hsl_to_rgb(hsl);
}
