#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 ModelViewMatrixInverse;
uniform mat3 ViewNormalMatrix;

in vec3 POSITION;
in vec3 TEXCOORD;

out vec3 ray_pos;
out vec3 ray_dir;
out vec3 eyeDir;
out vec3 lightDir;

#include <atmosphere_model_include.vert>

void main()
{
	// camera position in model space
	vec4 camPt = ModelViewMatrixInverse[3]; //ModelViewMatrixInverse * vec4(0.0, 0.0, 0.0, 1.0);

	ray_pos = TEXCOORD;
	ray_dir = POSITION - camPt.xyz;

	eyeDir = -vec3(ModelViewMatrix * vec4(0.0, 0.0, 0.0, 1.0));
	lightDir = ViewNormalMatrix * SunDirection;;

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
