#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;
uniform samplerBuffer instance_data;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec2 uv;

void main()
{
	mat4 m;
	m[0] = texelFetch(instance_data, gl_InstanceID*4 + 0);
	m[1] = texelFetch(instance_data, gl_InstanceID*4 + 1);
	m[2] = texelFetch(instance_data, gl_InstanceID*4 + 2);
	m[3] = texelFetch(instance_data, gl_InstanceID*4 + 3);
	vec4 pos = m * vec4(POSITION, 1.0);

	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;
	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
