#version 330 core

uniform mat4 ProjectionMatrix;
uniform float time;

uniform vec3 XAxis;
uniform vec3 YAxis;

in vec3 params[1]; // radius, time, 1/mass

out vec2 uv;
out float alpha;
out vec3 ec_pos;

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

#define EMIT_VERTEX(VTX, UV) \
	uv = (UV); \
	alpha = falloff; \
	ec_pos = VTX; \
	gl_Position = ProjectionMatrix * vec4((VTX), 1.0); \
	EmitVertex()

void main()
{
	float t = time - params[0].y;
	if ( t < 0.0 || t > 4.0 ) return;

	float intensity = 1.0 - smoothstep(0.0, 1.0, t*0.25);
	float radius = params[0].x + (1.0 - intensity);

	vec4 pos = gl_in[0].gl_Position;
	float dist = dot(vec3(0.0, 0.0, -1.0), pos.xyz ) - 1.0;
	float falloff = smoothstep(0.0, 1.0, dist) * intensity * params[0].z;
	if ( falloff <= 0.0 ) return;

	vec3 a = pos.xyz + (XAxis + YAxis)*radius;
	vec3 b = pos.xyz + (YAxis - XAxis)*radius;
	vec3 c = pos.xyz + (-XAxis - YAxis)*radius;
	vec3 d = pos.xyz + (XAxis - YAxis)*radius;

	EMIT_VERTEX(a, vec2(1.0, 0.0));
	EMIT_VERTEX(b, vec2(0.0, 0.0));
	EMIT_VERTEX(d, vec2(1.0, 1.0));
	EMIT_VERTEX(c, vec2(0.0, 1.0));

	EndPrimitive();
}
