#version 330 core

uniform sampler2D diffuse;
uniform sampler2D normal_depth;
uniform samplerCube cubemap;
uniform vec2 viewport;

in vec2 uv;
in vec3 light_pos;
in vec3 normal;
in vec3 opos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 nd = textureLod(normal_depth, uv_pos, 0.0);

	vec3 pos = calc_position(uv_pos, nd.w);
	if ( pos.z > light_pos.z ) discard;

	vec3 n = normalize(normal);
	//float lum = abs(dot(n, vec3(0.0, 0.0, 1.0)));
	float lum = abs(dot(n, vec3(1.0, 0.0, 0.0)));
	lum += abs(dot(n, vec3(0.0, 1.0, 0.0)));
	lum += abs(dot(n, vec3(0.0, 0.0, 1.0)));
	lum /= 3.0;
	float alpha = clamp((light_pos.z - pos.z), 0.0, 1.0) * pow(lum, 4.0);

	//vec3 cn = normalize(opos);
	//cn.y = -cn.y;
	//vec3 color = textureLod(cubemap, cn, 0.0).rgb;
	frag_color.rgb = texture(diffuse, uv).xxx * vec3(0.8, 0.9, 1.0) * alpha;
	frag_color.a = 0.0;
}
