#version 330 core

uniform sampler2D diffuse;
uniform sampler2D normal_depth;
uniform vec2 viewport;

in vec2 uv;
in vec3 ec_pos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 nd = textureLod(normal_depth, uv_pos, 0.0);

	vec3 pos = calc_position(uv_pos, nd.w);
	if ( pos.z > ec_pos.z ) discard;

	float alpha = 0.35*clamp((ec_pos.z - pos.z), 0.0, 1.0);

	frag_color.rgb = texture(diffuse, uv).rgb * alpha;
	frag_color.a = 0.0;
}
