#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <post/blit_include.frag>

void main()
{
#if 1
	vec2 uv2 = distort_uv(uv);
	vec4 color = texture(color_buffer, uv2);
	frag_color = color_lookup(color);
#else
	frag_color = texture(normal_depth, uv).rgba*0.5 + vec4(0.5);
	//frag_color = texture(diffuse_specular, uv);
#endif
}
